;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/bexit.scm                    */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun 12 10:06:03 1992                          */
;*    Last change :  Mon Sep 21 16:40:20 1998 (serrano)                */
;*                                                                     */
;*    On test les trois sortes de `bind-exit'                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module bind-exit
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-bind-exit)
	    (bug-bexit-1 x)))

;*---------------------------------------------------------------------*/
;*    test0 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test0 n)
   (+ n
      (bind-exit (out)
	     (labels ((loop (m)
			    (if (= m 0)
				(out 1)
				(loop (- m 1)))))
		(loop n)
		2))))

;*---------------------------------------------------------------------*/
;*    test1                                                            */
;*---------------------------------------------------------------------*/
(define (test1 . l)
   (bind-exit (error)
	  (labels ((sum (l)
			(if (null? l)
			    0
			    (if (integer? (car l))
				(+ (car l) (sum (cdr l)))
				(error -1)))))
	     (sum l))))

;*---------------------------------------------------------------------*/
;*    test2                                                            */
;*---------------------------------------------------------------------*/
(define (call-with-current-continuation f)
   (bind-exit (c) (f c)))

(define test2 (lambda l
	       (call-with-current-continuation
		(lambda (error)
		   (labels ((sum (l)
				 (if (null? l)
				     0
				     (if (integer? (car l))
					 (+ (car l) (sum (cdr l)))
					 (error -1)))))
		      (sum l))))))

;*---------------------------------------------------------------------*/
;*    test4 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test4 f)
   (let ((kapture 1))
      (bind-exit (c) (f kapture c))))

;*---------------------------------------------------------------------*/
;*    Un code qui ne se compilait pas (jusqu'a Bigloo1.6b):            */
;*---------------------------------------------------------------------*/
(define bug-bexit-1
   (lambda (x1)
      (labels ((!-d.try1015 (!-d.1008)
			    (if :-d.1008
				(bind-exit
				 (!-d.staticexit1010)
				 0)
				0)))
	 (!-d.try1015 0))))

;*---------------------------------------------------------------------*/
;*    test5 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test5 x)
   (let ((g 0))
      (try (if (string? x)
	       (test5 '(1 2 3))
	       (car x))
	   (lambda (a b c d)
	      (if (=fx g 0)
		  (begin
		     (set! g (+fx g 1))
		     (a #t))
		  (a #f))))))

;*---------------------------------------------------------------------*/
;*    *escape* ...                                                     */
;*---------------------------------------------------------------------*/
(define *escape* #unspecified)

;*---------------------------------------------------------------------*/
;*    A bug in Cfa make this function return #unspecified.             */
;*---------------------------------------------------------------------*/
(define (test6)
   (let ((f (bind-exit (ex)
	       (lambda () 345))))
      (f)))

;*---------------------------------------------------------------------*/
;*    test-bind-exit ...                                               */
;*---------------------------------------------------------------------*/
(define (test-bind-exit)
   (test-module "bind-exit" "bind-exit.scm")
   (test "goto bind-exit" (test0 4) 5)
   (test "simple bind-exit" (test1 1 2 4) 7)
   (test "simple bind-exit" (test1 1 'toto 4) -1)
   (test "call-with-current-continuation" (test2 1 2 4) 7)
   (test "call-with-current-continuation" (test2 1 'toto 4) -1)
   (test "kapture bind-exit" (test4 (lambda (x y) x)) 1)
   (test "try" (begin
		  (try (error 1 2 3) (lambda (a b c d) (a #t)))
		  (try (test5 5)
		       (lambda (a b c d)
			  #f)))
	 #t)
   (test "try(next)" (try (error 1 2 3) (lambda (a b c d) (a #t))) #t)
   (test "cfa" (test6) 345)
   (test "unwind" (eval '(unwind-protect 10 10)) 10)
   (test "unwind" (eval '(bind-exit (exit) (unwind-protect (exit 10) 9))) 10)
   (test "unwind" (eval '(bind-exit (exit) (unwind-protect 10 9))) 10))
		 
	 
