;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;<font size="-3"><pre>
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/examples/Runtime/runtime.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jul  8 09:13:09 1995                          */
;*    Last change :  Thu Mar  6 09:42:35 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    An example of foreign function interface.                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_runtime
   
   (extern (include "sys/time.h")
	   (include "sys/resource.h")
	   (macro RUSAGE_SELF::int "RUSAGE_SELF")
	   (type timeval  (struct (tv-sec::long "tv_sec")
				  (tv-usec::long "tv_usec"))
		 "struct timeval")
	   (type timezone (struct (tz-minuteswest::int "tz_minuteswest")
				  (tz-dsttime::int "tz_dsttime"))
		 "struct timezone")
	   (type rusage   (struct (ru-utime::timeval "ru_utime")
				  (ru-stime::timeval "ru_stime")
				  (ru-maxrss::int "ru_maxrss")
				  (ru-ixrss::int "ru_ixrss")
				  (ru-idrss::int "ru_idrss")
				  (ru-isrss::int "ru_isrss")
				  (ru_minflt::int "ru_minflt")
				  (ru_majflt::int "ru_majflt")
				  (ru_nswap::int "ru_nswap")
				  (ru_inblock::int "ru_inblock")
				  (ru_oublock::int "ru_oublock")
				  (ru_msgsnd::int "ru_msgsnd")
				  (ru_msgrcv::int "ru_msgrcv")
				  (ru_nsignals::int "ru_nsignals")
				  (ru_nvcsw::int "ru_nvcsw")
				  (ru_nivcsw::int "ru_nivcsw"))
		 "struct rusage")
	   (getrusage::int (int rusage*) "getrusage"))

   (export (runtime::pair ::procedure))) 

;*---------------------------------------------------------------------*/
;*    runtime ...                                                      */
;*---------------------------------------------------------------------*/
(define (runtime thunk)
   (let ((rusage (make-rusage*)))
      (let* ((i     (getrusage RUSAGE_SELF rusage))
             (tu    (rusage*-ru-utime rusage))
             (ts    (rusage*-ru-stime rusage))
             (usec  (timeval*-tv-sec tu))
             (umsec (timeval*-tv-usec tu))
             (ssec  (timeval*-tv-sec ts))
             (smsec (timeval*-tv-usec ts)))
         (let ((val (thunk)))
            (let ((i  (getrusage RUSAGE_SELF rusage))
                  (tu (rusage*-ru-utime rusage))
                  (ts (rusage*-ru-stime rusage)))
               (cons val
		     (cons (+ (- (timeval*-tv-sec tu) usec)
			      (/ (- (timeval*-tv-usec tu) umsec)
				 1000000))
			   (+ (- (timeval*-tv-sec ts) ssec)
			      (/ (- (timeval*-tv-usec ts) smsec)
				 1000000)))))))))


(display "?* ")
(let loop ((exp (read)))
   (if (eof-object? exp)
       'done
       (let ((t (runtime (lambda () (try (eval exp)
					 (lambda (a b c d)
					    (notify-error b c d)
					    (a #unspecified)))))))
	  (print (car t) "  [" (car (cdr t)) " user + " (cdr (cdr t)) " sys]")
	  (display "?* ")
	  (loop (read)))))
;</pre></font>
