;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;<font size="-3"><pre>
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/examples/Roman/roman.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  SERRANO Manuel                                    */
;*    Creation    :  Tue Dec 22 08:44:51 1992                          */
;*    Last change :  Mon Jan 18 20:40:06 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Reading and computing on Roman numbers                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module roman (main main))

;*---------------------------------------------------------------------*/
;*    roman->arabic ...                                                */
;*---------------------------------------------------------------------*/
(define (roman->arabic r)
   (define (chiffre.roman->arabic chiffre)
      (case chiffre
	 ((#\m #\M) 1000)
	 ((#\d #\D) 500)
	 ((#\c #\C) 100)
	 ((#\l #\L) 50)
	 ((#\x #\X) 10)
	 ((#\v #\V) 5)
	 ((#\i #\I) 1)
	 (else
	  (error "chiffre" "Illegal char" chiffre))))
   (let ((len (string-length r)))
      (let loop ((indice 0))
      (cond
	 ((= indice len)
	  0)
	 ((= indice (- len 1))
	  (chiffre.roman->arabic (string-ref r indice)))
	 (else
	  (let ((x (chiffre.roman->arabic (string-ref r indice)))
		(y (chiffre.roman->arabic (string-ref r (+ 1 indice)))))
	     (if (< x y)
		 (+ (- x) (loop (+ 1 indice)))
		 (+ x (loop (+ 1 indice))))))))))

;*---------------------------------------------------------------------*/
;*    grammar-roman ...                                                */
;*---------------------------------------------------------------------*/
(define grammar-roman
   (let ((par-open 0))
      (regular-grammar ((arabic (in "09"))
			(roman  (uncase "ivxlcdm")))
	 ((+ (in #\space #\newline #\tab))
	  (ignore))
	 ((+ arabic)
	  (string->integer (the-string)))
	 ((+ roman)
	  (roman->arabic (the-string)))
	 (#\(
	  (let ((open-key par-open))
	     (set! par-open (+ 1 par-open))
	     (rgc-context 'pair)
	     (let loop-pair ((walk (ignore))) 
		(cond
		   ((= open-key par-open)
		    '())
		   (else
		    (cons walk (loop-pair (ignore))))))))
	 (#\)
	  (set! par-open (- par-open 1))
	  (if (< par-open 0)
	      (begin
		 (set! par-open 0)
		 (ignore))
	      #f))
	 ((in "+-*\\")
	  (string->symbol (the-string)))
	 (else
	  (let ((char (the-failure)))
	     (if (eof-object? char)
		 char
		 (error "grammar-roman" "Illegal char" char)))))))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (let ((prompt ":-) "))
      (display prompt)
      (let loop ((exp (read/rp grammar-roman (current-input-port))))
	 (if (eof-object? exp)
	     'done
	     (begin
		(display* (eval exp) #\Newline prompt)
		(loop (read/rp grammar-roman (current-input-port))))))))
;</pre></font>
