;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
(module foo)


(define-struct int-point x y)
(define-struct real-point x y)

(define (is-in-circle? r p)
   (match-case p
      (#{int-point ?x ?y}
       (<=fx (+fx (*fx x x) (*fx y y)) (*fx r r)))
      (#{real-point ?x ?y}
       (<= (+fl (*fl x x) (*fl y y)) (* r r)))
      (else
       (error "is-in-circle?" "argument not a point" p))))

(define p-int (make-int-point))

(int-point-x-set! p-int 4)
(int-point-y-set! p-int -4)

(define p-real (make-real-point))

(real-point-x-set! p-real 4.4)
(real-point-y-set! p-real -4.4)

(print "is-in-circle? : " (is-in-circle? 10 p-int))
(print "is-in-circle? : " (is-in-circle? 10 p-real))


