;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/examples/Lib/scm-point.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 19 13:03:45 1998                          */
;*    Last change :  Sat Dec 19 18:56:34 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Scheme implementation of the point library                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module point
   (include "point.sch")
   (extern  (include "point.h"))
   (export  (make-point::s-point_2d* ::double ::double)
	    (print-point             ::s-point_2d*)
	    (point?                  ::obj))
   (eval    (export-all)))

;*---------------------------------------------------------------------*/
;*    make-point ...                                                   */
;*---------------------------------------------------------------------*/
(define (make-point::s-point_2d* x::double y::double)
   (s-point_2d* x y))

;*---------------------------------------------------------------------*/
;*    print-point ...                                                  */
;*---------------------------------------------------------------------*/
(define (print-point p::s-point_2d*)
   (print_point_2d p))

;*---------------------------------------------------------------------*/
;*    point? ...                                                       */
;*---------------------------------------------------------------------*/
(define (point? obj::obj)
   (s-point_2d*? obj)
   obj)
		 
