;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/examples/Args/args.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb 12 11:04:06 1996                          */
;*    Last change :  Wed Jan 14 15:09:58 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    An example of args.sch usage                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module args
   (include "args.sch")
   (main main))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (parse-args (cdr argv))
   (print "Parsing finished"))

;*---------------------------------------------------------------------*/
;*    usage ...                                                        */
;*---------------------------------------------------------------------*/
(define (usage)
   (print "usage: foo [options]")
   (parse-args 'usage))

;*---------------------------------------------------------------------*/
;*    parse-args ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-args argv)
   (let ((unmatched? #f))
      (args-parse argv
	 (("-o" ?name (synopsis "The name of the src file"))
	  (print "The source file is " name))
	 (("-o?name" (synopsis "An alternate way of providing src file"))
	  (print "The source file is again " name))
	 (("-dummy" (synopsis "-dummy" "A dummy option"))
	  (print "One dummy option"))
	 (("-dummy2" ?dummy1 ?dummy2 (synopsis "-dummy2 <arg1> <arg2>"
					       "A dummy option with 2 args"))
	  (print "One dummy option with 2 args"))
	 (("-help")
	  (args-parse-usage))
	 (else
	  (if unmatched?
	      (args-parse-error else)
	      (begin
		 (set! unmatched? #t)
		 (print "An unmatched argument: " else)))))))

 
