;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Write/version.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Mar 12 14:03:51 1995                          */
;*    Last change :  Thu Oct 29 14:08:17 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La version de Bigloo.                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module write_version 
   (import engine_param
	   tools_speek)
   (export (version)
	   (short-version)
	   (revision)))

;*---------------------------------------------------------------------*/
;*    revision ...                                                     */
;*---------------------------------------------------------------------*/
(define (revision)
   (print *bigloo-version* (if (char? *bigloo-level*) *bigloo-level* "")))

;*---------------------------------------------------------------------*/
;*    short-version ...                                                */
;*---------------------------------------------------------------------*/
(define (short-version)
   (print *bigloo-name* (if (char? *bigloo-level*)
			    (string-append " (level "
					   (make-string 1 *bigloo-level*)
					   ")")
			    "")))

;*---------------------------------------------------------------------*/
;*    version ...                                                      */
;*---------------------------------------------------------------------*/
(define (version)
   (display-to-column "" 79 #\-)
   (newline)
   (horse (string-append *bigloo-name*
			 (if (char? *bigloo-level*)
			     (string-append " (level "
					    (make-string 1 *bigloo-level*)
					    ")")
			     ""))
	  "`a practical Scheme compiler'"
	  (if (char=? (string-ref *bigloo-date* 0) #\space)
	      (substring *bigloo-date* 1 (string-length *bigloo-date*))
	      *bigloo-date*)
	  *bigloo-author*
	  "email:"
	  *bigloo-email*)
   (if (>=fx *verbose* 3)
       (begin
	  (display-to-column " " 78 #\-)
	  (newline)
	  (verbose 3 " Ce travail est dedie a Nelly Lebas, ma grand-mere, decedee le 10 Mars 1995," #\Newline)
	  (verbose 3 " ainsi qu'a Marcel Lebas, mon grand-pere, decede le 29 Octobre 1998." #\Newline)))
   (display-to-column "" 79 #\-)
   (newline)
   (newline))

;*---------------------------------------------------------------------*/
;*    horse ...                                                        */
;*---------------------------------------------------------------------*/
(define (horse . l)
   (let loop ((l     l)
	      (horse '("            ,--^, "
		       "      _ ___/ /|/  "
		       "  ,;'( )__, ) '   "
		       " ;;  //   L__.    " 
		       " '   \\    /  '    "
		       "      ^   ^       ")))
      (cond
	 ((null? l)
	  (if (null? horse)
	      'done
	      (begin
		 (display-to-column "" 62 #\space)
		 (print (car horse))
		 (loop '() (cdr horse)))))
	 ((null? horse)
	  (print (car l))
	  (loop (cdr l) '()))
	 (else
	  (display-to-column (car l) 62 #\space)
	  (print (car horse))
	  (loop (cdr l) (cdr horse))))))

;*---------------------------------------------------------------------*/
;*    display-to-column ...                                            */
;*---------------------------------------------------------------------*/
(define (display-to-column string column char)
   (display string)
   (let loop ((l (+fx 1 (string-length string))))
      (if (=fx l column)
	  'done
	  (begin
	     (write-char char)
	     (loop (+fx l 1))))))   
      
