;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Write/scheme.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 15:07:23 1994                          */
;*    Last change :  Thu Jun 13 14:44:25 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Some tools to write Scheme code.                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module write_scheme
   (import engine_param)
   (export (write-scheme-file-header ::output-port string)
	   (write-scheme-comment     ::output-port . sexp)))

;*---------------------------------------------------------------------*/
;*    write-scheme-file-header ...                                     */
;*---------------------------------------------------------------------*/
(define (write-scheme-file-header port string)
   (fprint port ";; =========================================================")
   (fprint port ";; " string)
   (fprint port ";; " *bigloo-name*)
   (fprint port ";; " *bigloo-author* " (c)      " *bigloo-date*)
   (fprint port ";; =========================================================")
   (newline port))

;*---------------------------------------------------------------------*/
;*    write-scheme-comment ...                                         */
;*---------------------------------------------------------------------*/
(define (write-scheme-comment port . sexp)
   (cond
      ((null? sexp)
       (fprint port ";;"))
      ((null? (cdr sexp))
       (fprint port ";; " (car sexp)))
      (else
       (apply fprint (cons* port ";; " sexp)))))

