;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Write/expanded.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 15:03:54 1994                          */
;*    Last change :  Wed May 27 08:58:11 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The pretty-print of expanded module.                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module write_expanded
   (include "Ast/unit.sch")
   (import  engine_param
	    write_scheme
	    tools_args
	    tools_file
	    ast_unit
	    module_module)
   (export  (write-expanded expanded)))

;*---------------------------------------------------------------------*/
;*    write-expanded ...                                               */
;*---------------------------------------------------------------------*/
(define (write-expanded units)
   (let* ((output-name (cond
			  ((string? *dest*)
			   *dest*)
			  ((eq? *dest* '--to-stdout)
			   #f)
			  ((and (pair? *src-files*)
				(string? (car *src-files*)))
			   (string-append (prefix (car *src-files*))
					  ".escm"))
			  (else
			   #f)))
	  (port        (if (string? output-name)
			   (open-output-file output-name)
			   (current-output-port))))
      (if (not (output-port? port))
	  (error "write-expanded" "Can't open output file" output-name)
	  (unwind-protect
	     (begin
		(set! *pp-case* 'lower)
		(write-scheme-file-header port "The expanded module")
		(write-scheme-comment port "The module clause")
		(pp *module-clause* port)
		(newline port)
		(for-each
		 (lambda (u)
		    (if (unit-printable? u)
			(begin
			   (if (pair? (unit-sexp* u))
			       (write-scheme-comment port
						     (string-append
						      "unit: "
						      (symbol->string
						       (unit-id u)))))
			   ;; we loop on all units
			   (for-each
			    (lambda (code)
			       ;; we loop on all expression in a unit
			       (match-case code
				  ((define (?name . ?args) ?value)
				   (write-scheme-comment port name)
				   (pp code port))
				  ((define ?name ?value)
				   (write-scheme-comment port name)
				   (pp code port))
				  ((define-inline (?name . ?args) ?value)
				   (write-scheme-comment port name)
				   (pp code port))
				  (else
				   (pp code port))))
			    (let ((code (unit-sexp* u)))
			       (if (procedure? code)
				   (force code)
				   code)))
			   (newline port))))
		 units))
	     (if (and (output-port? port)
		      (not (eq? port (current-output-port))))
		 (close-output-port port))))))
