;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Write/ast.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 31 07:29:03 1994                          */
;*    Last change :  Thu May 21 12:08:09 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The ast pretty-printer                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module write_ast
   (include "Engine/pass.sch"
	    "Ast/node.sch")
   (import  engine_param
	    init_main
	    write_scheme
	    type_pptype
	    tools_shape
	    tools_args)
   (export  (write-ast ast)))

;*---------------------------------------------------------------------*/
;*    write-ast ...                                                    */
;*---------------------------------------------------------------------*/
(define (write-ast globals)
   (let* ((output-name (if (string? *dest*)
			   *dest*
			   (if (and (pair? *src-files*)
				    (string? (car *src-files*)))
			       (string-append (prefix (car *src-files*))
					      ".ast")
			       #f)))
	  (port        (if (string? output-name)
			   (open-output-file output-name)
			   (current-output-port))))
      (if (not (output-port? port))
	  (error "write-ast" "Can't open output file" output-name)
	  (let ((handler (lambda (escape proc mes obj)
			    (notify-error proc mes obj)
			    (close-output-port port)
			    (exit-bigloo -8))))
	     (try (begin
		     (if (not *case-sensitive*)
			 (set! *pp-case* 'lower))
		     (write-scheme-file-header port
					       (string-append "The AST ("
							      *current-pass*
							      ")"))
		     (for-each
		      (lambda (g)
			 (let ((fun (global-value g)))
			    (write-scheme-comment port (shape g))
			    (write-scheme-comment port
						  (function-type->string g))
			    (write-scheme-comment port (make-sfun-sinfo g))
			    (pp `(,(case (sfun-class fun)
				      ((sgfun)
				       'define-generic)
				      ((sifun)
				       'define-inline)
				      ((smfun)
				       'define-method)
				      (else
				       'define))
				  ,(cons (shape g)
					 (args-list->args*
					  (map shape (sfun-args fun))
					  (sfun-arity fun)))
				  ,(shape (sfun-body fun)))
				port)))
		      globals)
		     (close-output-port port))
		  handler)))))

;*---------------------------------------------------------------------*/
;*    make-sfun-sinfo ...                                              */
;*---------------------------------------------------------------------*/
(define (make-sfun-sinfo::bstring g::global)
   (define (atom->string atom)
      (case atom
	 ((#t)
	  "#t")
	 ((#f)
	  "#f")
	 ((#unspecified)
	  "#unspecified")
	 (else
	  (cond
	     ((symbol? atom)
	      (if *case-sensitive*
		  (symbol->string atom)
		  (string-downcase (symbol->string atom))))
	     ((number? atom)
	      (number->string atom))
	     ((string? atom)
	      atom)
	     (else
	      (let ((p (open-output-string)))
		 (display atom p)
		 (close-output-port p)))))))
   (let ((sfun (global-value g)))
      (string-append "["
		     (if *case-sensitive*
			 (symbol->string (global-import g))
			 (string-downcase (symbol->string (global-import g))))
		     "  side-effect: " (atom->string (sfun-side-effect? sfun))
		     (let ((t (sfun-predicate-of sfun)))
			(if (type? t)
			    (string-append "  predicate-of: "
					   (atom->string (shape t)))
			    ""))
		     "  occ: " (integer->string (global-occurrence g))
		     "  rm: " (atom->string (global-removable g))
		     "  loc: " (let ((p (open-output-string)))
				  (display (sfun-loc sfun) p)
				  (close-output-port p))
		     (if (global-user? g)
			 "  user?: #t"
			 "  user?: #f")
		     "]")))
