/*===========================================================================*/
/*   (Write/ast.scm)                                                         */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>


/* Object type definitions */
typedef struct type
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     obj_t size;
     obj_t class;
     obj_t coerce_to_204;
     obj_t parents;
     bool_t init__47;
     bool_t magic__53;
     obj_t __57;
     obj_t alias;
     obj_t pointed_to_by_76;
     obj_t tvector;
  }
    *type_t;

typedef struct value
  {
     header_t header;
     obj_t widening;
  }
     *value_t;

typedef struct variable
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
  }
        *variable_t;

typedef struct global
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
     obj_t module;
     obj_t import;
     bool_t evaluable__248;
     bool_t library__255;
     bool_t user__32;
     obj_t pragma;
     obj_t src;
  }
      *global_t;

typedef struct local
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
     bool_t user__32;
     long key;
  }
     *local_t;

typedef struct fun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
  }
   *fun_t;

typedef struct sfun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
     obj_t property;
     obj_t args;
     obj_t body;
     obj_t class;
     obj_t dsssl_keywords_243;
     obj_t loc;
  }
    *sfun_t;

typedef struct cfun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
     obj_t args_type_205;
     bool_t macro__33;
     bool_t infix__163;
  }
    *cfun_t;

typedef struct svar
  {
     header_t header;
     obj_t widening;
     obj_t loc;
  }
    *svar_t;

typedef struct scnst
  {
     header_t header;
     obj_t widening;
     obj_t node;
     obj_t class;
     obj_t loc;
  }
     *scnst_t;

typedef struct cvar
  {
     header_t header;
     obj_t widening;
     bool_t macro__33;
  }
    *cvar_t;

typedef struct sexit
  {
     header_t header;
     obj_t widening;
     obj_t handler;
     bool_t detached__120;
  }
     *sexit_t;

typedef struct node
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
  }
    *node_t;

typedef struct node_effect_213
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
  }
               *node_effect_213_t;

typedef struct atom
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t value;
  }
    *atom_t;

typedef struct var
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct variable *variable;
  }
   *var_t;

typedef struct closure
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct variable *variable;
  }
       *closure_t;

typedef struct kwote
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t value;
  }
     *kwote_t;

typedef struct sequence
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t nodes;
  }
        *sequence_t;

typedef struct app
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct var *fun;
     obj_t args;
     obj_t stack_info_255;
  }
   *app_t;

typedef struct app_ly_162
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *fun;
     struct node *arg;
  }
          *app_ly_162_t;

typedef struct funcall
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *fun;
     obj_t args;
     obj_t strength;
  }
       *funcall_t;

typedef struct pragma
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t format;
     obj_t args;
  }
      *pragma_t;

typedef struct cast
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *arg;
  }
    *cast_t;

typedef struct setq
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *value;
  }
    *setq_t;

typedef struct conditional
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *test;
     struct node *true;
     struct node *false;
  }
           *conditional_t;

typedef struct fail
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *proc;
     struct node *msg;
     struct node *obj;
  }
    *fail_t;

typedef struct select
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *test;
     obj_t clauses;
     struct type *item_type_130;
  }
      *select_t;

typedef struct let_fun_218
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t locals;
     struct node *body;
  }
           *let_fun_218_t;

typedef struct let_var_6
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t bindings;
     struct node *body;
     bool_t removable__42;
  }
         *let_var_6_t;

typedef struct set_ex_it_116
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *body;
  }
             *set_ex_it_116_t;

typedef struct jump_ex_it_184
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *exit;
     struct node *value;
  }
              *jump_ex_it_184_t;

typedef struct make_box_202
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *value;
  }
            *make_box_202_t;

typedef struct box_ref_242
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct var *var;
  }
           *box_ref_242_t;

typedef struct box_set__221
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *value;
  }
            *box_set__221_t;


extern obj_t unwind_until__178___bexit(obj_t, obj_t);
extern char *number__string_214___r4_numbers_6_5(obj_t, obj_t);
extern obj_t display___r4_output_6_10_3(obj_t, obj_t);
extern obj_t _src_files__222_engine_param;
static obj_t method_init_76_write_ast();
extern obj_t current_output_port;
extern obj_t string_append(obj_t, obj_t);
extern obj_t exitd_top;
extern obj_t type_type_type;
extern obj_t write_scheme_comment_102_write_scheme(obj_t, obj_t);
static obj_t handling_function1456_write_ast(obj_t, obj_t, obj_t, obj_t);
static obj_t make_sfun_sinfo_243_write_ast(global_t);
extern bool_t is_a__118___object(obj_t, obj_t);
static obj_t atom__string_243_write_ast(obj_t);
extern obj_t module_initialization_70_write_ast(long, char *);
extern obj_t module_initialization_70_tools_speek(long, char *);
extern obj_t module_initialization_70_tools_error(long, char *);
extern obj_t module_initialization_70_engine_pass(long, char *);
extern obj_t module_initialization_70_type_type(long, char *);
extern obj_t module_initialization_70_ast_var(long, char *);
extern obj_t module_initialization_70_ast_node(long, char *);
extern obj_t module_initialization_70_engine_param(long, char *);
extern obj_t module_initialization_70_init_main(long, char *);
extern obj_t module_initialization_70_write_scheme(long, char *);
extern obj_t module_initialization_70_type_pptype(long, char *);
extern obj_t module_initialization_70_tools_shape(long, char *);
extern obj_t module_initialization_70_tools_args(long, char *);
extern obj_t module_initialization_70___error(long, char *);
extern obj_t module_initialization_70___os(long, char *);
extern obj_t module_initialization_70___bexit(long, char *);
extern obj_t module_initialization_70___object(long, char *);
extern obj_t module_initialization_70___reader(long, char *);
extern obj_t module_initialization_70___pp(long, char *);
extern obj_t module_initialization_70___r4_pairs_and_lists_6_3(long, char *);
extern obj_t module_initialization_70___r4_numbers_6_5(long, char *);
extern obj_t module_initialization_70___r4_numbers_6_5_fixnum(long, char *);
extern obj_t module_initialization_70___r4_strings_6_7(long, char *);
extern obj_t module_initialization_70___r4_control_features_6_9(long, char *);
extern obj_t module_initialization_70___r4_output_6_10_3(long, char *);
extern obj_t notify_error_43___error(obj_t, obj_t, obj_t);
extern obj_t write_ast_133_write_ast(obj_t);
extern obj_t exit_bigloo_229_init_main(obj_t);
static obj_t imported_modules_init_94_write_ast();
extern obj_t string_append_106___r4_strings_6_7(obj_t);
extern obj_t string_downcase_77___r4_strings_6_7(obj_t);
static obj_t rhandler1438_write_ast(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t _pp_case__242___pp;
extern obj_t _dest__217_engine_param;
static obj_t handler_write_ast(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t prefix___os(obj_t);
static obj_t library_modules_init_112_write_ast();
extern obj_t open_input_string(obj_t);
static obj_t _write_ast_58_write_ast(obj_t, obj_t);
extern char *integer__string_135___r4_numbers_6_5_fixnum(long, obj_t);
extern obj_t close_output_port(obj_t);
extern obj_t string_to_bstring(char *);
extern obj_t _case_sensitive__90_engine_param;
extern obj_t dynamic_wind_31___r4_control_features_6_9(obj_t, obj_t, obj_t);
static obj_t arg1460_write_ast(obj_t);
static obj_t arg1458_write_ast(obj_t);
extern obj_t shape_tools_shape(obj_t);
extern obj_t function_type__string_79_type_pptype(variable_t);
extern obj_t open_output_string();
extern obj_t pp___pp(obj_t, obj_t);
extern obj_t remove_error_handler__102___error();
extern obj_t read___reader(obj_t);
extern obj_t cons__138___r4_pairs_and_lists_6_3(obj_t, obj_t);
extern obj_t args_list__args__33_tools_args(obj_t, obj_t);
static obj_t escape_write_ast(obj_t, obj_t);
extern obj_t add_error_handler__155___error(obj_t, obj_t);
extern obj_t open_output_file(obj_t);
static obj_t require_initialization_114_write_ast = BUNSPEC;
extern obj_t write_scheme_file_header_174_write_scheme(obj_t, obj_t);
static obj_t body1439_write_ast(obj_t);
static obj_t cnst_init_137_write_ast();
extern obj_t _current_pass__25_engine_pass;
static obj_t __cnst[8];

DEFINE_STRING(string1699_write_ast, string1699_write_ast1715, "", 0);
DEFINE_STRING(string1709_write_ast, string1709_write_ast1716, "DEFINE DEFINE-METHOD SMFUN DEFINE-INLINE SIFUN DEFINE-GENERIC SGFUN LOWER ", 74);
DEFINE_STRING(string1698_write_ast, string1698_write_ast1717, "  predicate-of: ", 16);
DEFINE_STRING(string1708_write_ast, string1708_write_ast1718, "#unspecified", 12);
DEFINE_STRING(string1697_write_ast, string1697_write_ast1719, "The AST (", 9);
DEFINE_STRING(string1707_write_ast, string1707_write_ast1720, "#f", 2);
DEFINE_STRING(string1696_write_ast, string1696_write_ast1721, ")", 1);
DEFINE_STRING(string1706_write_ast, string1706_write_ast1722, "#t", 2);
DEFINE_STRING(string1695_write_ast, string1695_write_ast1723, "Can't open output file", 22);
DEFINE_STRING(string1705_write_ast, string1705_write_ast1724, "[", 1);
DEFINE_STRING(string1694_write_ast, string1694_write_ast1725, "write-ast", 9);
DEFINE_STRING(string1704_write_ast, string1704_write_ast1726, "  side-effect: ", 15);
DEFINE_STRING(string1693_write_ast, string1693_write_ast1727, ".ast", 4);
DEFINE_STRING(string1703_write_ast, string1703_write_ast1728, "  occ: ", 7);
DEFINE_STRING(string1702_write_ast, string1702_write_ast1729, "  rm: ", 6);
DEFINE_STRING(string1701_write_ast, string1701_write_ast1730, "  loc: ", 7);
DEFINE_STRING(string1700_write_ast, string1700_write_ast1731, "]", 1);
DEFINE_EXPORT_PROCEDURE(write_ast_env_248_write_ast, _write_ast_58_write_ast1732, _write_ast_58_write_ast, 0L, 1);


/* module-initialization */ obj_t 
module_initialization_70_write_ast(long checksum_1300, char *from_1301)
{
   if (CBOOL(require_initialization_114_write_ast))
     {
	require_initialization_114_write_ast = BBOOL(((bool_t) 0));
	library_modules_init_112_write_ast();
	cnst_init_137_write_ast();
	imported_modules_init_94_write_ast();
	method_init_76_write_ast();
	return BUNSPEC;
     }
   else
     {
	return BUNSPEC;
     }
}


/* library-modules-init */ obj_t 
library_modules_init_112_write_ast()
{
   module_initialization_70___bexit(((long) 0), "WRITE_AST");
   module_initialization_70___r4_numbers_6_5(((long) 0), "WRITE_AST");
   module_initialization_70___r4_output_6_10_3(((long) 0), "WRITE_AST");
   module_initialization_70___object(((long) 0), "WRITE_AST");
   module_initialization_70___error(((long) 0), "WRITE_AST");
   module_initialization_70___r4_strings_6_7(((long) 0), "WRITE_AST");
   module_initialization_70___pp(((long) 0), "WRITE_AST");
   module_initialization_70___os(((long) 0), "WRITE_AST");
   module_initialization_70___r4_numbers_6_5_fixnum(((long) 0), "WRITE_AST");
   module_initialization_70___r4_control_features_6_9(((long) 0), "WRITE_AST");
   module_initialization_70___reader(((long) 0), "WRITE_AST");
   module_initialization_70___r4_pairs_and_lists_6_3(((long) 0), "WRITE_AST");
   return BUNSPEC;
}


/* cnst-init */ obj_t 
cnst_init_137_write_ast()
{
   {
      obj_t cnst_port_138_1292;
      cnst_port_138_1292 = open_input_string(string1709_write_ast);
      {
	 long i_1293;
	 i_1293 = ((long) 7);
       loop_1294:
	 {
	    bool_t test1710_1295;
	    test1710_1295 = (i_1293 == ((long) -1));
	    if (test1710_1295)
	      {
		 return BUNSPEC;
	      }
	    else
	      {
		 {
		    obj_t arg1711_1296;
		    {
		       obj_t list1712_1297;
		       {
			  obj_t arg1713_1298;
			  arg1713_1298 = BNIL;
			  list1712_1297 = MAKE_PAIR(cnst_port_138_1292, arg1713_1298);
		       }
		       arg1711_1296 = read___reader(list1712_1297);
		    }
		    CNST_TABLE_SET(i_1293, arg1711_1296);
		 }
		 {
		    int aux_1299;
		    {
		       long aux_1327;
		       aux_1327 = (i_1293 - ((long) 1));
		       aux_1299 = (int) (aux_1327);
		    }
		    {
		       long i_1330;
		       i_1330 = (long) (aux_1299);
		       i_1293 = i_1330;
		       goto loop_1294;
		    }
		 }
	      }
	 }
      }
   }
}


/* write-ast */ obj_t 
write_ast_133_write_ast(obj_t globals_1)
{
   {
      obj_t output_name_205_694;
      {
	 bool_t test1527_790;
	 {
	    obj_t obj_1184;
	    obj_1184 = _dest__217_engine_param;
	    test1527_790 = STRINGP(obj_1184);
	 }
	 if (test1527_790)
	   {
	      output_name_205_694 = _dest__217_engine_param;
	   }
	 else
	   {
	      bool_t test1528_791;
	      {
		 bool_t test1532_795;
		 {
		    obj_t obj_1185;
		    obj_1185 = _src_files__222_engine_param;
		    test1532_795 = PAIRP(obj_1185);
		 }
		 if (test1532_795)
		   {
		      obj_t arg1533_796;
		      {
			 obj_t pair_1186;
			 pair_1186 = _src_files__222_engine_param;
			 arg1533_796 = CAR(pair_1186);
		      }
		      test1528_791 = STRINGP(arg1533_796);
		   }
		 else
		   {
		      test1528_791 = ((bool_t) 0);
		   }
	      }
	      if (test1528_791)
		{
		   obj_t arg1529_792;
		   {
		      obj_t arg1531_794;
		      {
			 obj_t pair_1188;
			 pair_1188 = _src_files__222_engine_param;
			 arg1531_794 = CAR(pair_1188);
		      }
		      arg1529_792 = prefix___os(arg1531_794);
		   }
		   output_name_205_694 = string_append(arg1529_792, string1693_write_ast);
		}
	      else
		{
		   output_name_205_694 = BFALSE;
		}
	   }
      }
      {
	 obj_t port_695;
	 if (STRINGP(output_name_205_694))
	   {
	      port_695 = open_output_file(output_name_205_694);
	   }
	 else
	   {
	      port_695 = current_output_port;
	   }
	 {
	    if (OUTPUT_PORTP(port_695))
	      {
		 obj_t handler_1254;
		 handler_1254 = make_fx_procedure(handler_write_ast, ((long) 4), ((long) 1));
		 PROCEDURE_SET(handler_1254, ((long) 0), port_695);
		 {
		    obj_t armed1440_698;
		    obj_t handler1437_699;
		    armed1440_698 = MAKE_CELL(BUNSPEC);
		    handler1437_699 = MAKE_CELL(BUNSPEC);
		    {
		       obj_t body1439_1250;
		       obj_t rhandler1438_1252;
		       body1439_1250 = make_fx_procedure(body1439_write_ast, ((long) 0), ((long) 2));
		       rhandler1438_1252 = make_fx_procedure(rhandler1438_write_ast, ((long) 4), ((long) 2));
		       PROCEDURE_SET(body1439_1250, ((long) 0), port_695);
		       PROCEDURE_SET(body1439_1250, ((long) 1), globals_1);
		       PROCEDURE_SET(rhandler1438_1252, ((long) 0), armed1440_698);
		       PROCEDURE_SET(rhandler1438_1252, ((long) 1), handler1437_699);
		       CELL_SET(handler1437_699, handler_1254);
		       CELL_SET(armed1440_698, BTRUE);
		       return handling_function1456_write_ast(body1439_1250, rhandler1438_1252, handler1437_699, armed1440_698);
		    }
		 }
	      }
	    else
	      {
		 FAILURE(string1694_write_ast, string1695_write_ast, output_name_205_694);
	      }
	 }
      }
   }
}


/* handling_function1456 */ obj_t 
handling_function1456_write_ast(obj_t body1439_1291, obj_t rhandler1438_1290, obj_t handler1437_1289, obj_t armed1440_1288)
{
   jmp_buf jmpbuf;
   obj_t an_exit1448_703;
   if (SET_EXIT(an_exit1448_703))
     {
	RESTORE_TRACE();
	return _exit_value_;
     }
   else
     {
	an_exit1448_703 = (obj_t) jmpbuf;
	{
	   PUSH_EXIT(an_exit1448_703, ((bool_t) 1));
	   {
	      obj_t an_exitd1449_704;
	      an_exitd1449_704 = exitd_top;
	      {
		 obj_t escape_1251;
		 escape_1251 = make_fx_procedure(escape_write_ast, ((long) 1), ((long) 1));
		 PROCEDURE_SET(escape_1251, ((long) 0), an_exitd1449_704);
		 {
		    obj_t res1451_707;
		    {
		       obj_t arg1460_1249;
		       obj_t arg1458_1253;
		       arg1460_1249 = make_fx_procedure(arg1460_write_ast, ((long) 0), ((long) 1));
		       arg1458_1253 = make_fx_procedure(arg1458_write_ast, ((long) 0), ((long) 5));
		       PROCEDURE_SET(arg1460_1249, ((long) 0), armed1440_1288);
		       PROCEDURE_SET(arg1458_1253, ((long) 0), an_exitd1449_704);
		       PROCEDURE_SET(arg1458_1253, ((long) 1), armed1440_1288);
		       PROCEDURE_SET(arg1458_1253, ((long) 2), handler1437_1289);
		       PROCEDURE_SET(arg1458_1253, ((long) 3), rhandler1438_1290);
		       PROCEDURE_SET(arg1458_1253, ((long) 4), escape_1251);
		       res1451_707 = dynamic_wind_31___r4_control_features_6_9(arg1458_1253, body1439_1291, arg1460_1249);
		    }
		    POP_EXIT();
		    return res1451_707;
		 }
	      }
	   }
	}
     }
}


/* _write-ast */ obj_t 
_write_ast_58_write_ast(obj_t env_1255, obj_t globals_1256)
{
   return write_ast_133_write_ast(globals_1256);
}


/* arg1460 */ obj_t 
arg1460_write_ast(obj_t env_1257)
{
   {
      obj_t armed1440_1258;
      armed1440_1258 = PROCEDURE_REF(env_1257, ((long) 0));
      {
	 {
	    bool_t test_1374;
	    {
	       obj_t aux_1375;
	       aux_1375 = CELL_REF(armed1440_1258);
	       test_1374 = CBOOL(aux_1375);
	    }
	    if (test_1374)
	      {
		 CELL_SET(armed1440_1258, BFALSE);
		 return remove_error_handler__102___error();
	      }
	    else
	      {
		 return BUNSPEC;
	      }
	 }
      }
   }
}


/* body1439 */ obj_t 
body1439_write_ast(obj_t env_1260)
{
   {
      obj_t port_1261;
      obj_t globals_1262;
      port_1261 = PROCEDURE_REF(env_1260, ((long) 0));
      globals_1262 = PROCEDURE_REF(env_1260, ((long) 1));
      {
	 if (CBOOL(_case_sensitive__90_engine_param))
	   {
	      BUNSPEC;
	   }
	 else
	   {
	      _pp_case__242___pp = CNST_TABLE_REF(((long) 0));
	   }
	 {
	    obj_t arg1465_720;
	    {
	       obj_t list1466_721;
	       {
		  obj_t arg1468_723;
		  {
		     obj_t arg1469_724;
		     arg1469_724 = MAKE_PAIR(string1696_write_ast, BNIL);
		     arg1468_723 = MAKE_PAIR(_current_pass__25_engine_pass, arg1469_724);
		  }
		  list1466_721 = MAKE_PAIR(string1697_write_ast, arg1468_723);
	       }
	       arg1465_720 = string_append_106___r4_strings_6_7(list1466_721);
	    }
	    write_scheme_file_header_174_write_scheme(port_1261, arg1465_720);
	 }
	 {
	    obj_t l1441_727;
	    l1441_727 = globals_1262;
	  lname1442_728:
	    if (PAIRP(l1441_727))
	      {
		 {
		    obj_t g_730;
		    g_730 = CAR(l1441_727);
		    {
		       value_t fun_731;
		       {
			  global_t obj_1194;
			  obj_1194 = (global_t) (g_730);
			  fun_731 = (((global_t) CREF(obj_1194))->value);
		       }
		       {
			  obj_t arg1473_732;
			  arg1473_732 = shape_tools_shape(g_730);
			  {
			     obj_t list1474_733;
			     list1474_733 = MAKE_PAIR(arg1473_732, BNIL);
			     write_scheme_comment_102_write_scheme(port_1261, list1474_733);
			  }
		       }
		       {
			  obj_t arg1476_735;
			  arg1476_735 = function_type__string_79_type_pptype((variable_t) (g_730));
			  {
			     obj_t list1477_736;
			     list1477_736 = MAKE_PAIR(arg1476_735, BNIL);
			     write_scheme_comment_102_write_scheme(port_1261, list1477_736);
			  }
		       }
		       {
			  obj_t arg1479_738;
			  arg1479_738 = make_sfun_sinfo_243_write_ast((global_t) (g_730));
			  {
			     obj_t list1480_739;
			     list1480_739 = MAKE_PAIR(arg1479_738, BNIL);
			     write_scheme_comment_102_write_scheme(port_1261, list1480_739);
			  }
		       }
		       {
			  obj_t arg1483_741;
			  {
			     obj_t arg1486_744;
			     obj_t arg1487_745;
			     obj_t arg1488_746;
			     {
				obj_t case_value_58_752;
				{
				   sfun_t obj_1195;
				   obj_1195 = (sfun_t) (fun_731);
				   case_value_58_752 = (((sfun_t) CREF(obj_1195))->class);
				}
				{
				   bool_t test_1406;
				   {
				      obj_t aux_1407;
				      aux_1407 = CNST_TABLE_REF(((long) 1));
				      test_1406 = (case_value_58_752 == aux_1407);
				   }
				   if (test_1406)
				     {
					arg1486_744 = CNST_TABLE_REF(((long) 2));
				     }
				   else
				     {
					bool_t test_1411;
					{
					   obj_t aux_1412;
					   aux_1412 = CNST_TABLE_REF(((long) 3));
					   test_1411 = (case_value_58_752 == aux_1412);
					}
					if (test_1411)
					  {
					     arg1486_744 = CNST_TABLE_REF(((long) 4));
					  }
					else
					  {
					     bool_t test_1416;
					     {
						obj_t aux_1417;
						aux_1417 = CNST_TABLE_REF(((long) 5));
						test_1416 = (case_value_58_752 == aux_1417);
					     }
					     if (test_1416)
					       {
						  arg1486_744 = CNST_TABLE_REF(((long) 6));
					       }
					     else
					       {
						  arg1486_744 = CNST_TABLE_REF(((long) 7));
					       }
					  }
				     }
				}
			     }
			     {
				obj_t arg1503_759;
				obj_t arg1504_760;
				arg1503_759 = shape_tools_shape(g_730);
				{
				   obj_t arg1505_761;
				   long arg1507_762;
				   {
				      obj_t l1443_763;
				      {
					 sfun_t obj_1202;
					 obj_1202 = (sfun_t) (fun_731);
					 l1443_763 = (((sfun_t) CREF(obj_1202))->args);
				      }
				      if (NULLP(l1443_763))
					{
					   arg1505_761 = BNIL;
					}
				      else
					{
					   obj_t head1445_765;
					   {
					      obj_t arg1517_776;
					      arg1517_776 = shape_tools_shape(CAR(l1443_763));
					      head1445_765 = MAKE_PAIR(arg1517_776, BNIL);
					   }
					   {
					      obj_t l1443_766;
					      obj_t tail1446_767;
					      l1443_766 = CDR(l1443_763);
					      tail1446_767 = head1445_765;
					    lname1444_768:
					      if (NULLP(l1443_766))
						{
						   arg1505_761 = head1445_765;
						}
					      else
						{
						   obj_t newtail1447_771;
						   {
						      obj_t arg1514_773;
						      arg1514_773 = shape_tools_shape(CAR(l1443_766));
						      newtail1447_771 = MAKE_PAIR(arg1514_773, BNIL);
						   }
						   SET_CDR(tail1446_767, newtail1447_771);
						   {
						      obj_t tail1446_1438;
						      obj_t l1443_1436;
						      l1443_1436 = CDR(l1443_766);
						      tail1446_1438 = newtail1447_771;
						      tail1446_767 = tail1446_1438;
						      l1443_766 = l1443_1436;
						      goto lname1444_768;
						   }
						}
					   }
					}
				   }
				   {
				      sfun_t obj_1215;
				      obj_1215 = (sfun_t) (fun_731);
				      arg1507_762 = (((sfun_t) CREF(obj_1215))->arity);
				   }
				   arg1504_760 = args_list__args__33_tools_args(arg1505_761, BINT(arg1507_762));
				}
				arg1487_745 = MAKE_PAIR(arg1503_759, arg1504_760);
			     }
			     {
				obj_t aux_1445;
				{
				   sfun_t obj_1218;
				   obj_1218 = (sfun_t) (fun_731);
				   aux_1445 = (((sfun_t) CREF(obj_1218))->body);
				}
				arg1488_746 = shape_tools_shape(aux_1445);
			     }
			     {
				obj_t list1490_748;
				{
				   obj_t arg1491_749;
				   {
				      obj_t arg1494_750;
				      arg1494_750 = MAKE_PAIR(BNIL, BNIL);
				      arg1491_749 = MAKE_PAIR(arg1488_746, arg1494_750);
				   }
				   list1490_748 = MAKE_PAIR(arg1487_745, arg1491_749);
				}
				arg1483_741 = cons__138___r4_pairs_and_lists_6_3(arg1486_744, list1490_748);
			     }
			  }
			  {
			     obj_t list1484_742;
			     list1484_742 = MAKE_PAIR(port_1261, BNIL);
			     pp___pp(arg1483_741, list1484_742);
			  }
		       }
		    }
		 }
		 {
		    obj_t l1441_1455;
		    l1441_1455 = CDR(l1441_727);
		    l1441_727 = l1441_1455;
		    goto lname1442_728;
		 }
	      }
	    else
	      {
		 ((bool_t) 1);
	      }
	 }
	 return close_output_port(port_1261);
      }
   }
}


/* arg1458 */ obj_t 
arg1458_write_ast(obj_t env_1263)
{
   {
      obj_t rhandler1438_1267;
      obj_t escape_1268;
      rhandler1438_1267 = PROCEDURE_REF(env_1263, ((long) 3));
      escape_1268 = PROCEDURE_REF(env_1263, ((long) 4));
      {
	 return add_error_handler__155___error(rhandler1438_1267, escape_1268);
      }
   }
}


/* escape */ obj_t 
escape_write_ast(obj_t env_1269, obj_t val1450_1271)
{
   {
      obj_t an_exitd1449_1270;
      an_exitd1449_1270 = PROCEDURE_REF(env_1269, ((long) 0));
      {
	 obj_t val1450_705;
	 val1450_705 = val1450_1271;
	 return unwind_until__178___bexit(an_exitd1449_1270, val1450_705);
      }
   }
}


/* rhandler1438 */ obj_t 
rhandler1438_write_ast(obj_t env_1272, obj_t esc_1275, obj_t obj_1276, obj_t proc_1277, obj_t msg_1278)
{
   {
      obj_t armed1440_1273;
      obj_t handler1437_1274;
      armed1440_1273 = PROCEDURE_REF(env_1272, ((long) 0));
      handler1437_1274 = PROCEDURE_REF(env_1272, ((long) 1));
      {
	 obj_t esc_714;
	 obj_t obj_715;
	 obj_t proc_716;
	 obj_t msg_717;
	 esc_714 = esc_1275;
	 obj_715 = obj_1276;
	 proc_716 = proc_1277;
	 msg_717 = msg_1278;
	 CELL_SET(armed1440_1273, BFALSE);
	 remove_error_handler__102___error();
	 {
	    obj_t aux_1467;
	    aux_1467 = CELL_REF(handler1437_1274);
	    return PROCEDURE_ENTRY(aux_1467) (CELL_REF(handler1437_1274), esc_714, obj_715, proc_716, msg_717, BEOA);
	 }
      }
   }
}


/* handler */ obj_t 
handler_write_ast(obj_t env_1280, obj_t escape_1282, obj_t proc_1283, obj_t mes_1284, obj_t obj_1285)
{
   {
      obj_t port_1281;
      port_1281 = PROCEDURE_REF(env_1280, ((long) 0));
      {
	 obj_t escape_783;
	 obj_t proc_784;
	 obj_t mes_785;
	 obj_t obj_786;
	 escape_783 = escape_1282;
	 proc_784 = proc_1283;
	 mes_785 = mes_1284;
	 obj_786 = obj_1285;
	 notify_error_43___error(proc_784, mes_785, obj_786);
	 close_output_port(port_1281);
	 return exit_bigloo_229_init_main(BINT(((long) -8)));
      }
   }
}


/* make-sfun-sinfo */ obj_t 
make_sfun_sinfo_243_write_ast(global_t g_2)
{
   {
      value_t sfun_798;
      sfun_798 = (((global_t) CREF(g_2))->value);
      {
	 obj_t arg1535_800;
	 obj_t arg1537_802;
	 obj_t arg1539_803;
	 char *arg1542_805;
	 obj_t arg1548_807;
	 obj_t arg1550_809;
	 char *arg1552_810;
	 if (CBOOL(_case_sensitive__90_engine_param))
	   {
	      obj_t aux_1476;
	      aux_1476 = (((global_t) CREF(g_2))->import);
	      arg1535_800 = SYMBOL_TO_STRING(aux_1476);
	   }
	 else
	   {
	      obj_t arg1570_827;
	      {
		 obj_t aux_1479;
		 aux_1479 = (((global_t) CREF(g_2))->import);
		 arg1570_827 = SYMBOL_TO_STRING(aux_1479);
	      }
	      arg1535_800 = string_downcase_77___r4_strings_6_7(arg1570_827);
	   }
	 {
	    obj_t aux_1483;
	    {
	       sfun_t obj_1230;
	       obj_1230 = (sfun_t) (sfun_798);
	       aux_1483 = (((sfun_t) CREF(obj_1230))->side_effect__165);
	    }
	    arg1537_802 = atom__string_243_write_ast(aux_1483);
	 }
	 {
	    obj_t t_830;
	    {
	       sfun_t obj_1231;
	       obj_1231 = (sfun_t) (sfun_798);
	       t_830 = (((sfun_t) CREF(obj_1231))->predicate_of_78);
	    }
	    {
	       bool_t test1574_831;
	       test1574_831 = is_a__118___object(t_830, type_type_type);
	       if (test1574_831)
		 {
		    obj_t arg1578_833;
		    {
		       obj_t arg1580_834;
		       arg1580_834 = shape_tools_shape(t_830);
		       arg1578_833 = atom__string_243_write_ast(arg1580_834);
		    }
		    arg1539_803 = string_append(string1698_write_ast, arg1578_833);
		 }
	       else
		 {
		    arg1539_803 = string1699_write_ast;
		 }
	    }
	 }
	 arg1542_805 = integer__string_135___r4_numbers_6_5_fixnum((((global_t) CREF(g_2))->occurrence), BNIL);
	 arg1548_807 = atom__string_243_write_ast((((global_t) CREF(g_2))->removable));
	 {
	    obj_t p_838;
	    p_838 = open_output_string();
	    {
	       obj_t arg1584_839;
	       {
		  sfun_t obj_1235;
		  obj_1235 = (sfun_t) (sfun_798);
		  arg1584_839 = (((sfun_t) CREF(obj_1235))->loc);
	       }
	       {
		  obj_t list1585_840;
		  list1585_840 = MAKE_PAIR(p_838, BNIL);
		  display___r4_output_6_10_3(arg1584_839, list1585_840);
	       }
	    }
	    arg1550_809 = close_output_port(p_838);
	 }
	 if ((((global_t) CREF(g_2))->user__32))
	   {
	      arg1552_810 = "  user?: #t";
	   }
	 else
	   {
	      arg1552_810 = "  user?: #f";
	   }
	 {
	    obj_t list1554_812;
	    {
	       obj_t arg1555_813;
	       {
		  obj_t arg1556_814;
		  {
		     obj_t arg1557_815;
		     {
			obj_t arg1558_816;
			{
			   obj_t arg1559_817;
			   {
			      obj_t arg1560_818;
			      {
				 obj_t arg1561_819;
				 {
				    obj_t arg1562_820;
				    {
				       obj_t arg1563_821;
				       {
					  obj_t arg1564_822;
					  {
					     obj_t arg1565_823;
					     {
						obj_t arg1566_824;
						arg1566_824 = MAKE_PAIR(string1700_write_ast, BNIL);
						{
						   obj_t aux_1507;
						   aux_1507 = string_to_bstring(arg1552_810);
						   arg1565_823 = MAKE_PAIR(aux_1507, arg1566_824);
						}
					     }
					     arg1564_822 = MAKE_PAIR(arg1550_809, arg1565_823);
					  }
					  arg1563_821 = MAKE_PAIR(string1701_write_ast, arg1564_822);
				       }
				       arg1562_820 = MAKE_PAIR(arg1548_807, arg1563_821);
				    }
				    arg1561_819 = MAKE_PAIR(string1702_write_ast, arg1562_820);
				 }
				 {
				    obj_t aux_1514;
				    aux_1514 = string_to_bstring(arg1542_805);
				    arg1560_818 = MAKE_PAIR(aux_1514, arg1561_819);
				 }
			      }
			      arg1559_817 = MAKE_PAIR(string1703_write_ast, arg1560_818);
			   }
			   arg1558_816 = MAKE_PAIR(arg1539_803, arg1559_817);
			}
			arg1557_815 = MAKE_PAIR(arg1537_802, arg1558_816);
		     }
		     arg1556_814 = MAKE_PAIR(string1704_write_ast, arg1557_815);
		  }
		  arg1555_813 = MAKE_PAIR(arg1535_800, arg1556_814);
	       }
	       list1554_812 = MAKE_PAIR(string1705_write_ast, arg1555_813);
	    }
	    return string_append_106___r4_strings_6_7(list1554_812);
	 }
      }
   }
}


/* atom->string */ obj_t 
atom__string_243_write_ast(obj_t atom_843)
{
   {
      {
	 long aux1454_846;
	 if (CNSTP(atom_843))
	   {
	      aux1454_846 = CCNST(atom_843);
	   }
	 else
	   {
	      aux1454_846 = ((long) -1);
	   }
	 switch (aux1454_846)
	   {
	   case ((long) 2):
	      return string1706_write_ast;
	      break;
	   case ((long) 1):
	      return string1707_write_ast;
	      break;
	   case ((long) 3):
	      return string1708_write_ast;
	      break;
	   default:
	      if (SYMBOLP(atom_843))
		{
		   if (CBOOL(_case_sensitive__90_engine_param))
		     {
			return SYMBOL_TO_STRING(atom_843);
		     }
		   else
		     {
			obj_t arg1592_851;
			arg1592_851 = SYMBOL_TO_STRING(atom_843);
			return string_downcase_77___r4_strings_6_7(arg1592_851);
		     }
		}
	      else
		{
		   bool_t test_1534;
		   if (INTEGERP(atom_843))
		     {
			test_1534 = ((bool_t) 1);
		     }
		   else
		     {
			test_1534 = REALP(atom_843);
		     }
		   if (test_1534)
		     {
			{
			   char *aux_1538;
			   aux_1538 = number__string_214___r4_numbers_6_5(atom_843, BNIL);
			   return string_to_bstring(aux_1538);
			}
		     }
		   else
		     {
			if (STRINGP(atom_843))
			  {
			     return atom_843;
			  }
			else
			  {
			     {
				obj_t p_855;
				p_855 = open_output_string();
				{
				   obj_t list1596_856;
				   list1596_856 = MAKE_PAIR(p_855, BNIL);
				   display___r4_output_6_10_3(atom_843, list1596_856);
				}
				return close_output_port(p_855);
			     }
			  }
		     }
		}
	   }
      }
   }
}


/* method-init */ obj_t 
method_init_76_write_ast()
{
   return BUNSPEC;
}


/* imported-modules-init */ obj_t 
imported_modules_init_94_write_ast()
{
   module_initialization_70_tools_speek(((long) 0), "WRITE_AST");
   module_initialization_70_tools_error(((long) 0), "WRITE_AST");
   module_initialization_70_engine_pass(((long) 0), "WRITE_AST");
   module_initialization_70_type_type(((long) 0), "WRITE_AST");
   module_initialization_70_ast_var(((long) 0), "WRITE_AST");
   module_initialization_70_ast_node(((long) 0), "WRITE_AST");
   module_initialization_70_engine_param(((long) 0), "WRITE_AST");
   module_initialization_70_init_main(((long) 0), "WRITE_AST");
   module_initialization_70_write_scheme(((long) 0), "WRITE_AST");
   module_initialization_70_type_pptype(((long) 0), "WRITE_AST");
   module_initialization_70_tools_shape(((long) 0), "WRITE_AST");
   return module_initialization_70_tools_args(((long) 0), "WRITE_AST");
}
