;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/User/user.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 14:52:11 1994                          */
;*    Last change :  Tue Nov 17 07:27:14 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The entry user point                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module user_user
   (include "Engine/pass.sch"
	    "Ast/unit.sch")
   (import  engine_param
	    module_include
	    tools_speek
	    tools_error)
   (export  (user-walk units)))

;*---------------------------------------------------------------------*/
;*    user-walk ...                                                    */
;*---------------------------------------------------------------------*/
(define (user-walk units)
   (if (procedure? *user-pass*)
       (let ((unit (get-toplevel-unit)))
	  (pass-prelude *user-pass-name*)
	  (if (procedure? (unit-sexp* unit))
	      ;; a freezed unit (such as the eval
	      ;; unit) cannot be walked.
	      'nothing
	      (unit-sexp*-set! unit (*user-pass* (unit-sexp* unit))))
	  (pass-postlude 'dummy))
       'done))


