;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Type/type.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu May 30 16:38:54 1996                          */
;*    Last change :  Tue Dec 22 16:41:11 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The type class definition                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module type_type

   (import tools_location)
   
   (export (final-class type::object
	      ;; the type identifier
	      (id::symbol read-only (default '_))
	      ;; the target type name
	      (name (default #unspecified))
	      ;; the expression used by sizeof
	      (size (default #unspecified))
	      ;; the kind of type
	      (class (default 'bigloo)
		 [assert (class) (memq class '(_ bigloo C))])
	      ;; the coercion-to list
	      (coerce-to::obj (default '()))
	      ;; its parents
	      (parents::obj (default '()))
	      ;; initialized ? (a type can be only declared (use-type))
	      init?::bool
	      ;; is this type can be converted into every thing ?
	      (magic?::bool (default #f))
	      ;; is the type name containing a `$' ?
	      ($ (default #t))
	      ;; a type than self is aliasing
	      (alias (default #f))
	      ;; a type that points to self
	      (pointed-to-by (default #f))
	      ;; a tvector associated to this type
	      ;; (only used by the cfa but much easier to make it general)
	      (tvector (default #unspecified)))

	   (get-aliased-type::type ::type)

	   (bigloo-type?::bool ::type)))

;*---------------------------------------------------------------------*/
;*    get-aliased-type ...                                             */
;*---------------------------------------------------------------------*/
(define (get-aliased-type type)
   (let loop ((type type))
      (if (type? (type-alias type))
	  (loop (type-alias type))
	  type)))

;*---------------------------------------------------------------------*/
;*    bigloo-type? ...                                                 */
;*---------------------------------------------------------------------*/
(define (bigloo-type? type)
   (eq? (type-class type) 'bigloo))
   
