;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Type/pptype.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 31 08:28:30 1994                          */
;*    Last change :  Tue Jun 11 16:46:26 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The type pretty-printer                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module type_pptype
   (import type_type
	   ast_var)
   (export (function-type->string::bstring ::variable)
	   (variable-type->string::bstring ::variable)))

;*---------------------------------------------------------------------*/
;*    type-id->string ...                                              */
;*---------------------------------------------------------------------*/
(define (type-id->string type)
   (if (not (type? type))
       "_"
       (string-downcase (symbol->string (type-id type)))))

;*---------------------------------------------------------------------*/
;*    function-type->string ...                                        */
;*---------------------------------------------------------------------*/
(define (function-type->string variable)
   (let ((sfun (variable-value variable)))
      (string-append (let loop ((args (sfun-args sfun)))
			(if (null? args)
			    ""
			    (string-append
			     (string-downcase
			      (symbol->string
			       (type-id (local-type (car args)))))
			     (if (null? (cdr args))
				 ""
				 " x ")
			     (loop (cdr args)))))
		     " -> "
		     (string-downcase
		      (symbol->string (type-id (variable-type variable)))))))

;*---------------------------------------------------------------------*/
;*    variable-type->string ...                                        */
;*---------------------------------------------------------------------*/
(define (variable-type->string variable)
   (string-downcase (symbol->string (type-id (variable-type variable)))))
