;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Type/cache.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jan 18 11:28:43 1995                          */
;*    Last change :  Fri Feb  6 16:48:12 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    A small type cache to avoid to many lookup in Tenv.              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module type_cache
   (import type_type
	   type_env)
   (export (install-type-cache!)
           *obj*
           *cobj*
	   *cell*
	   *magic*
	   *void*
	   *bint*
	   *int*
	   *long*
	   *bool*
	   *bbool*
	   *real*
	   *char*
	   *bnil*
	   *pair*
	   *string*
	   *bstring*
	   *symbol*
	   *keyword*
	   *vector*
	   *struct*
	   *unspec*
	   *procedure*
	   *exit*
	   *_*
	   (get-default-type::type)
	   (set-default-type! ::type)
	   (get-object-type)))

;*---------------------------------------------------------------------*/
;*    install-type-cache! ...                                          */
;*---------------------------------------------------------------------*/
(define (install-type-cache!)
   (set! *obj*        (use-type! 'obj))
   (set! *cobj*       (use-type! 'cobj))
   (set! *cell*       (use-type! 'cell))
   (set! *magic*      (use-type! 'magic))
   (set! *void*       (use-type! 'void))
   (set! *bint*       (use-type! 'bint))
   (set! *int*        (use-type! 'int))
   (set! *long*       (use-type! 'long))
   (set! *bool*       (use-type! 'bool))
   (set! *bbool*      (use-type! 'bbool))
   (set! *real*       (use-type! 'double))
   (set! *char*       (use-type! 'uchar))
   (set! *pair*       (use-type! 'pair))
   (set! *bnil*       (use-type! 'nil))
   (set! *string*     (use-type! 'string))
   (set! *bstring*    (use-type! 'bstring))
   (set! *symbol*     (use-type! 'symbol))
   (set! *keyword*    (use-type! 'keyword))
   (set! *vector*     (use-type! 'vector))
   (set! *struct*     (use-type! 'struct))
   (set! *procedure*  (use-type! 'procedure))
   (set! *unspec*     (use-type! 'unspecified))
   (set! *exit*       (use-type! 'exit))
   (set! *object*     (if (type-exists? 'object)
			  (find-type 'object)
			  #f))
   (set! *_*          (use-type! '_))
   (set! *default-type* *_*))

;*---------------------------------------------------------------------*/
;*    The register cache                                               */
;*---------------------------------------------------------------------*/
(define *obj*          'no-type-yet)
(define *cobj*         'no-type-yet)
(define *cell*         'no-type-yet)
(define *magic*        'no-type-yet)
(define *void*         'no-type-yet)
(define *bint*         'no-type-yet)
(define *int*          'no-type-yet)
(define *long*         'no-type-yet)
(define *bool*         'no-type-yet)
(define *bbool*        'no-type-yet)
(define *real*         'no-type-yet)
(define *char*         'no-type-yet)
(define *string*       'no-type-yet)
(define *bstring*      'no-type-yet)
(define *symbol*       'no-type-yet)
(define *keyword*      'no-type-yet)
(define *pair*         'no-type-yet)
(define *bnil*         'no-type-yet)
(define *vector*       'no-type-yet)
(define *struct*       'no-type-yet)
(define *procedure*    'no-type-yet)
(define *unspec*       'no-type-yet)
(define *exit*         'no-type-yet)
(define *object*       'no-type-yet)
(define *_*            'no-type-yet)
(define *default-type* 'no-type-yet)

;*---------------------------------------------------------------------*/
;*    get-default-type ...                                             */
;*    -------------------------------------------------------------    */
;*    The default type is not a legal type that can be used in a       */
;*    foreign clause. Otherwise, the use-foreign-type! function        */
;*    implementation is incorrect.                                     */
;*---------------------------------------------------------------------*/
(define (get-default-type)
   *default-type*)

;*---------------------------------------------------------------------*/
;*    set-default-type! ...                                            */
;*---------------------------------------------------------------------*/
(define (set-default-type! type)
   (set! *default-type* type))

;*---------------------------------------------------------------------*/
;*    get-object-type ...                                              */
;*---------------------------------------------------------------------*/
(define (get-object-type)
   (cond
      ((type? *object*)
       *object*)
      (else
       (set! *object* (find-type 'object))
       *object*)))
