;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Tvector/access.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 27 13:33:40 1995                          */
;*    Last change :  Tue Aug  5 10:17:13 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We install all the coercer and accessor for `tvector' types.     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tvector_access
   (import  tools_misc
	    type_type
	    type_env
	    engine_param
	    tvector_tvector
	    module_module)
   (export  (make-tvector-accesses tvector::tvec ::obj)))

;*---------------------------------------------------------------------*/
;*    make-tvector-accesses ...                                        */
;*---------------------------------------------------------------------*/
(define (make-tvector-accesses tv::tvec src)
   (let* ((tv-id             (tvec-id tv))
	  (tv-name           (tvec-name tv))
	  (obj               (find-type 'obj))
	  (item-type         (tvec-item-type tv))
	  (item-id           (type-id item-type))
	  (item-name         (type-name item-type))
	  (descr-id          (symbol-append tv-id '-descriptor))
	  (tv-make-id        (symbol-append 'make- tv-id))
	  (tv-alloc-id       (symbol-append 'allocate- tv-id))
	  (tv-make-stack-id  (symbol-append 'make-stack- tv-id))
	  (tv-alloc-stack-id (symbol-append 'allocate-stack- tv-id))
	  (tv-ref-id         (symbol-append tv-id '-ref))
	  (tv-set!-id        (symbol-append tv-id '-set!))
	  (tv?-id            (symbol-append tv-id '?))
	  (tv->vector-id     (symbol-append tv-id '->vector))
	  (vector->tv-id     (symbol-append 'vector-> tv-id))
	  (tv->list          (symbol-append tv-id '->list))
	  (tv-length-id      (symbol-append tv-id '-length)))
      
      (define (make-descr)
	 `(define ,(symbol-append descr-id '::obj)
	     ((@ declare-tvector! __tvector)
	      ,tv-name
	      ,tv-alloc-id
	      ,tv-ref-id
	      ,tv-set!-id)))
      
      (define (make-tv?)
	 `(define-inline (,(symbol-append tv?-id '::bool) o::obj)
	     (if (tvector? o)
		 (eq? (tvector-descr o) ,descr-id)
		 #f)))
      
      (define (make-tv-ref)
	 (let* ((pfmt (string-append "TVECTOR_REF( " item-name ",$1,$2 )"))
		(pragma-id  (symbol-append 'pragma 4dots item-id))
		(pragma-exp `(,pragma-id ,pfmt tv o)))
	    `(define-inline (,(symbol-append tv-ref-id 4dots item-id)
			     ,(symbol-append 'tv 4dots tv-id)
			     o::long)
	     ,(if *unsafe-range*
		  pragma-exp
		  `(if (vector-bound-check? o (tvector-length tv))
		       ,pragma-exp
		       (error ,tv-ref-id "Index out of bounds" o))))))
      
      (define (make-tv-set!)
	 (let* ((pfmt (string-append "TVECTOR_SET( " item-name ",$1,$2,$3 )"))
		(pragma-id  'pragma::obj)
		(pragma-exp `(,pragma-id ,pfmt tv o v)))
	 `(define-inline (,(symbol-append tv-set!-id '::obj)
			  ,(symbol-append 'tv 4dots tv-id)
 			  o::long
			  ,(symbol-append 'v 4dots item-id))
	     ,(if *unsafe-range*
		  pragma-exp
		  `(if (vector-bound-check? o (tvector-length tv))
		       ,pragma-exp
		       (error ,(string-append (symbol->string tv-id) "-set!")
			      "Index out of bounds"
			      o))))))
      
      (define (make-tv)
	 `(define-inline (,(symbol-append tv-make-id 4dots tv-id)
			  len::long
			  ,(symbol-append 'v 4dots item-id))
	     (let ((,(symbol-append 'tv 4dots tv-id) (,tv-alloc-id len)))
		(labels ((loop (i::long)
			       (if (=fx i len)
				   tv
				   (let ((ni::long (+fx i 1)))
				      (,tv-set!-id tv i v)
				      (loop ni)))))
		   (loop 0)))))
      
      (define (make-stack-tv)
	 `(define-inline (,(symbol-append tv-make-stack-id 4dots tv-id)
			  len::long
			  ,(symbol-append 'v 4dots item-id))
	     (let ((,(symbol-append 'tv 4dots tv-id) (,tv-alloc-stack-id len)))
		(labels ((loop (i::long)
			       (if (=fx i len)
				   tv
				   (let ((ni::long (+fx i 1)))
				      (,tv-set!-id tv i v)
				      (loop ni)))))
		   (loop 0)))))
      
      (define (make-alloc-tv)
	 `(define-inline (,(symbol-append tv-alloc-id 4dots tv-id) len::long)
	     (,(symbol-append 'pragma 4dots tv-id)
	      "ALLOCATE_TVECTOR( $1, $2, $3 )"
	      (free-pragma ,item-name)
	      len
	      ,descr-id)))
      
      (define (make-alloc-stack-tv)
	 `(define-inline (,(symbol-append tv-alloc-stack-id 4dots tv-id) l::long)
	     (,(symbol-append 'pragma 4dots tv-id)
	      "ALLOCATE_S_TVECTOR( $1, $2, $3 )"
	      (free-pragma ,item-name)
	      l
	      ,descr-id)))
      
      (define (make-tv->vector)
	 `(define-inline (,(symbol-append tv->vector-id '::vector)
			  ,(symbol-append 'tv 4dots tv-id))
	     (tvector->vector tv)))

      (define (make-tv->list)
	 `(define (,(symbol-append tv->list '::obj)
		   ,(symbol-append 'tv 4dots tv-id))
	     (let ((len::long (,tv-length-id tv)))
		(if (=fx len 0)
		    '()
		    (labels ((loop (i::long acc::obj)
				   (if (=fx i 0)
				       (cons (,tv-ref-id tv i) acc)
				       (loop (-fx i 1)
					     (cons (,tv-ref-id tv i) acc)))))
		       (loop (-fx len 1) '()))))))
      
      (define (make-vector->tv)
	 `(define-inline (,(symbol-append vector->tv-id 4dots tv-id) v::vector)
	     (vector->tvector ',tv-id v)))
      
      (define (make-tv-length)
	 `(define-inline (,(symbol-append tv-length-id '::long)
			  ,(symbol-append 'o 4dots tv-id))
	     (tvector-length o)))

      ;; we parse a pragma clause for predicate and allocator and accessors
      (produce-module-clause!
       `(static ;; tv?
	        (inline ,(symbol-append tv?-id '::bool)
			::obj)
		;; tv-ref
		(inline ,(symbol-append tv-ref-id 4dots item-id)
			,(symbol-append 'tv 4dots tv-id)
			::long)
		;; tv-set!
		(inline ,(symbol-append tv-set!-id '::obj)
			,(symbol-append 'tv 4dots tv-id)
			::long
			,(symbol-append 'v 4dots item-id))
		;; make-tv
		(inline ,(symbol-append tv-make-id 4dots tv-id)
			::long
			,(symbol-append 4dots item-id))
		;; stack-tv
		(inline ,(symbol-append tv-make-stack-id 4dots tv-id)
			::long
			,(symbol-append 4dots item-id))
		;; alloc-tv
		(inline ,(symbol-append tv-alloc-id 4dots tv-id)
			::long)
		;; alloc-stack-tv
		(inline ,(symbol-append tv-alloc-stack-id 4dots tv-id)
			::long)
		;; tv->vector
		(inline ,(symbol-append tv->vector-id '::vector)
			,(symbol-append 'tv 4dots tv-id))
		;; vector->tv
		(inline ,(symbol-append vector->tv-id 4dots tv-id) 
			::vector)
		;; tv-length
		(inline ,(symbol-append tv-length-id '::long)
			,(symbol-append 'o 4dots tv-id))
		;; tv->list
		(,(symbol-append tv->list '::obj)
		 ,(symbol-append 'tv 4dots tv-id))))
      
      (produce-module-clause!
       `(pragma (,tv?-id (predicate-of ,tv-id))
		(,tv-make-id (stack-alloc ,tv-make-stack-id))
		(,tv-alloc-id (stack-alloc ,tv-alloc-stack-id))))

      ;; and we return the definitions
      (list (make-descr)
	    (make-tv?)
	    (make-tv-ref)
	    (make-tv-set!)
	    (make-tv)
	    (make-stack-tv)
	    (make-alloc-tv)
	    (make-alloc-stack-tv)
	    (make-tv->vector)
	    (make-vector->tv)
	    (make-tv-length)
	    (make-tv->list))))
