;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Tools/trace.sch             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 31 08:56:22 1993                          */
;*    Last change :  Sat May 23 18:58:36 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The tracing macro.                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Les imports indispensables pour pouvoir tracer                   */
;*---------------------------------------------------------------------*/
(directives
   (import tools_trace))

;*---------------------------------------------------------------------*/
;*    trace ...                                                        */
;*---------------------------------------------------------------------*/
(define-macro (trace mask . forms)
   (let ((*debug-mode* #f))
      (let ((*pass-names* '(ast heap inline cfa cc effect expand
			    globalize integrate coerce cnst cgen reduce
			    recovery)))
	 (if *debug-mode*
	     (match-case mask
		((? symbol?)
		 (if (eq? mask 'get-pass-names)
		     `',*pass-names*
		     (if (memq mask *pass-names*)
			 `(if (trace-satisfy? ',mask 0)
			      (print-trace ,@forms))
			 (error #f "Illegal `trace' expression" mask))))
		(((and ?pass (? symbol?)) (and ?level (? integer?)))
		 (if (memq pass *pass-names*)
		     `(if (trace-satisfy? ',pass ,level)
			  (print-trace ,@forms))
		     (error #f "Illegal `trace' expression" mask)))
		(else
		 (error #f "Illegal `trace' expression" mask)))))))
