;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Tools/shape.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 17:02:04 1994                          */
;*    Last change :  Sat Oct 17 07:35:29 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    In order to print human readable messages, we designed this      */
;*    tool.                                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_shape
   (include "Ast/node.sch"
	    "Tvector/tvector.sch")
   (import  ast_dump
	    ast_env
	    engine_param
	    tools_error)
   (export  (generic shape ::obj)))

;*---------------------------------------------------------------------*/
;*    local-string-downcase ...                                        */
;*---------------------------------------------------------------------*/
(define (local-string-downcase string)
   (if *case-sensitive*
       string
       (string-downcase string)))

;*---------------------------------------------------------------------*/
;*    shape ...                                                        */
;*---------------------------------------------------------------------*/
(define-generic (shape exp::obj)
   (cond
      ((pair? exp)
       (let loop ((exp exp))
	  (cond
	     ((null? exp)
	      '())
	     ((not (pair? exp))
	      (shape exp))
	     (else
	      (cons (shape (car exp)) (loop (cdr exp)))))))
      ((vector? exp)
       (let* ((len (vector-length exp))
	      (res (make-vector len '())))
	  (let loop ((indice 0))
	     (if (=fx indice len)
		 res
		 (begin
		    (vector-set! res
				 indice
				 (shape (vector-ref exp indice)))
		    (loop (+fx indice 1)))))))
      ((a-tvector? exp)
       (a-tvector (shape (a-tvector-type exp)) (shape (a-tvector-vector exp))))
      ((struct? exp)
       (let* ((key (struct-key exp))
	      (len (struct-length exp))
	      (res (make-struct key len '())))
	  (let loop ((indice 0))
	     (if (=fx indice len)
		 res
		 (begin
		    (struct-set! res
				 indice
				 (shape (struct-ref exp indice)))
		    (loop (+fx indice 1)))))))
      (else
       exp)))

;*---------------------------------------------------------------------*/
;*    shape ::global                                                   */
;*---------------------------------------------------------------------*/
(define-method (shape var::global)
   (let* ((str-id (local-string-downcase (symbol->string (global-id var))))
	  (id     (string->symbol str-id))
	  (module (local-string-downcase (symbol->string (global-module var))))
	  (type   (global-type var))
	  (tshape (if (not *type-shape?*)
		      ""
		      (string-append "::" (shape type))))
	  (ashape (cond
		     ((not *access-shape?*)
		      "")
		     (else
		      (string-append "{" (local-string-downcase
					  (symbol->string
					   (global-access var)))
				     "}")))))
      (cond
	 (*module-shape?*
	  (string->symbol (string-append str-id
					 "@"
					 module
					 tshape
					 ashape)))
	 (else
	  (case (global-bucket-position (global-id var) (global-module var))
	     ((-1)
	      (internal-error "global-shape"
			      "Can't find global any more"
			      `(@ ,id ,(global-module var))))
	     ((0)
	      (symbol-append id
			     (string->symbol tshape)
			     (string->symbol ashape)))
	     (else
	      (let ((sym (symbol-append id
					(string->symbol tshape)
					(string->symbol ashape))))
		 `(@ ,sym ,(string->symbol module)))))))))

;*---------------------------------------------------------------------*/
;*    shape ::local                                                    */
;*---------------------------------------------------------------------*/
(define-method (shape var::local)
   (let* ((sym    (if *key-shape?*
		      (symbol-append (local-id var)
				     '_
				     (string->symbol
				      (integer->string (local-key var))))
		      (local-id var)))
	  (sym    (local-string-downcase (symbol->string sym)))
	  (type   (local-type var))
	  (tshape (if (not *type-shape?*)
		      ""
		      (string-append "::" (shape type))))
	  (ushape (if (not *user-shape?*)
		      ""
		      (if (local-user? var)
			  "-<user>"
			  "-<no-user>")))
	  (ashape (cond
		     ((not *access-shape?*)
		      "")
		     (else
		      (string-append "{" (local-string-downcase
					  (symbol->string
					   (local-access var)))
				     "}")))))
      (string->symbol (string-append sym tshape ushape ashape))))
   
;*---------------------------------------------------------------------*/
;*    shape ::type ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (shape type::type)
   (local-string-downcase (symbol->string (type-id type))))

;*---------------------------------------------------------------------*/
;*    shape ::node ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (shape node::node)
   (node->sexp node))
   
