;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Tools/progn.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 11:08:04 1994                          */
;*    Last change :  Wed Apr  1 15:44:46 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The code sequence normalization.                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_progn
   (import tools_misc
	   tools_error)
   (export (normalize-progn <expression>)))

;*---------------------------------------------------------------------*/
;*    normalize-progn ...                                              */
;*    sexp --> sexp                                                    */
;*---------------------------------------------------------------------*/
(define (normalize-progn body*)
   (cond
      ((not (pair? body*))
       (internal-error "normalize-progn" "Illegal expression" body*))
      ((null? (cdr body*))
       (match-case (car body*)
	  ((begin . ?exps)
	   (normalize-progn exps))
	  (else
	   (car body*))))
      (else
       (let ((res `(begin ,@(let loop ((body* (if (eq? (car body*) 'begin)
						  (cdr body*)
						  body*)))
			       (if (null? body*)
				   '()
				   (let ((expr (car body*)))
				      (if (and (pair? expr)
					       (eq? (car expr) 'begin))
					  (append (cdr expr)
						  (loop (cdr body*)))
					  (cons expr
						(loop (cdr body*))))))))))
	  (replace! body* res)))))

