;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Tools/location.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 31 10:00:44 1996                          */
;*    Last change :  Thu May  7 16:28:17 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The location managment                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module ...                                                   */
;*---------------------------------------------------------------------*/
(module tools_location
   (include "Tools/location.sch")
   (import  engine_param)
   (export  (find-location                <s-exp>)
	    (find-location/loc            <s-exp> ::obj)
	    (location-full-fname::bstring ::obj)
	    (location-shape               ::obj ::obj)))

;*---------------------------------------------------------------------*/
;*    find-location ...                                                */
;*---------------------------------------------------------------------*/
(define (find-location exp)
   (define (parse-location loc)
      (match-case loc
	 ((at ?fname ?pos)
	  (warning "find-location" "obsolete `at' format -- " loc))
	 ((at ?fname ?pos ?lnum)
	  (location fname pos lnum))
	 (else
	  #f)))      
   (cond
      ((epair? exp)
       ;; easy the location has been directly produced by the reader.
       (parse-location (cer exp)))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    find-location/loc ...                                            */
;*---------------------------------------------------------------------*/
(define (find-location/loc exp loc)
   (let ((new-loc (find-location exp)))
      (if (location? new-loc)
	  new-loc
	  loc)))

;*---------------------------------------------------------------------*/
;*    location-full-fname ...                                          */
;*---------------------------------------------------------------------*/
(define (location-full-fname loc)
   (let* ((file-name (location-fname loc))
	  (pwd       (let ((vpwd (getenv "PWD")))
			(if (string? vpwd)
			    vpwd
			    (pwd))))
	  (full-name (make-file-name pwd file-name)))
      (if (file-exists? full-name)
	  full-name
	  (let ((lib-name (make-file-name *lib-src-dir* file-name)))
	     (if (file-exists? lib-name)
		 lib-name
		 file-name)))))

;*---------------------------------------------------------------------*/
;*    location-shape ...                                               */
;*---------------------------------------------------------------------*/
(define (location-shape loc l)
   (if (and *location-shape?* (location? loc))
       (cons (vector (string->symbol (location-fname loc))
		     ;; we use string->symbol just to avoid the #"..." printing
		     (location-pos loc)
		     (location-lnum loc))
	     l)
       l))
       



