;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Tools/error.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 25 10:47:51 1994                          */
;*    Last change :  Mon Aug  5 10:34:07 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Error utilities                                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_error
   (include "Tools/location.sch"
	    "Ast/node.sch")
   (import  engine_pass
	    engine_param
	    tools_location
	    tools_trace
	    init_main)
   (export  *nb-error-on-pass*
	    (internal-error        <obj> <obj> <obj>)
	    (user-warning          <obj> <obj> <obj>)
	    (user-warning/location ::obj <obj> <obj> <obj>)
	    (user-error            <obj> <obj> <obj> . <obj>)
	    (user-error/location   ::obj <obj> <obj> <obj> . <obj>)
	    (current-function)
	    (enter-function        ::symbol)
	    (leave-function)))

;*---------------------------------------------------------------------*/
;*    This hack is used to always compile this file without -g mode.   */
;*    Otherwise error msg locations are not relevant because they      */
;*    are said to be in this file.                                     */
;*---------------------------------------------------------------------*/
(define-macro (no-debug-mode)
   ;; the variable *compiler-debug* is bound in the module
   ;; engine_param of the compiler
   (set! *compiler-debug* 0)
   #unspecified)

(no-debug-mode)  

;*---------------------------------------------------------------------*/
;*    *nb-error-on-pass* ...                                           */
;*---------------------------------------------------------------------*/
(define *nb-error-on-pass* 0)

;*---------------------------------------------------------------------*/
;*    internal-error ...                                               */
;*---------------------------------------------------------------------*/
(define (internal-error proc mes obj)
   (if (output-port? *trace-port*)
       (fprint *trace-port* "*** ERROR: " proc ":" mes ":" obj))
   (fprint (current-error-port)
	   "*** INTERNAL-ERROR in pass: " *current-pass*)
   (fprint (current-error-port)
	   "(Would you, please, send this error report and the source file to"
	   #\Newline
	   *bigloo-author* " [" *bigloo-email* "], thank you.)")
   (error proc mes obj)
   (exit-bigloo -1))

;*---------------------------------------------------------------------*/
;*    user-warning/location ...                                        */
;*---------------------------------------------------------------------*/
(define (user-warning/location loc proc mes obj)
   (if (not (location? loc))
       (warning proc mes " -- " obj)
       (warning/location (location-fname loc)
			 (location-pos loc)
			 proc
			 mes
			 " -- "
			 obj)))
   
;*---------------------------------------------------------------------*/
;*    user-warning ...                                                 */
;*---------------------------------------------------------------------*/
(define (user-warning proc mes obj)
   (user-warning/location (find-location obj) proc mes obj))
   
;*---------------------------------------------------------------------*/
;*    user-error ...                                                   */
;*---------------------------------------------------------------------*/
(define (user-error proc mes obj . continue)
   (if (pair? continue)
       (user-error/location (find-location obj) proc mes obj
			    (car continue))
       (user-error/location (find-location obj) proc mes obj)))

;*---------------------------------------------------------------------*/
;*    user-error/location ...                                          */
;*---------------------------------------------------------------------*/
(define (user-error/location loc proc mes obj . continue)
   (if (output-port? *trace-port*)
       (fprint *trace-port*  "*** ERROR:" proc ":" mes ":" obj))
   (set! *nb-error-on-pass* (+fx *nb-error-on-pass* 1))
   (let* ((proc-string (cond
			  ((string? proc)
			   proc)
			  ((symbol? proc)
			   (symbol->string proc))
			  (else
			   #f)))
	  (fun-string  (symbol->string (current-function)))
	  (proc        (if (and (string? proc-string)
				(not (string=? proc-string fun-string)))
			   (string-append fun-string ":" proc-string)
			   fun-string)))
      (let ((obj-prn  (let ((port (open-output-string)))
			 (display obj port)
			 (let ((string (close-output-port port)))
			    (if (>fx (string-length string) 45)
				(string-append (substring string 0 44) " ...")
				string))))
	    (handler  (lambda (escape proc mes obj)
			 (notify-error proc mes obj)
			 (escape (car continue)))))
	 (if (location? loc)
	     (if (pair? continue)
		 (try (error/location proc
				      mes
				      obj-prn
				      (location-fname loc)
				      (location-pos   loc))
		      handler) 
		 (error/location proc
				 mes
				 obj-prn
				 (location-fname loc)
				 (location-pos   loc)))
	     (if (pair? continue)
		 (try (error proc mes obj)
		      handler)
		 (error proc mes obj))))))
		 
;*---------------------------------------------------------------------*/
;*    *sfun-stack*                                                     */
;*---------------------------------------------------------------------*/
(define *sfun-stack* '(top-level))

;*---------------------------------------------------------------------*/
;*    enter-function ...                                               */
;*---------------------------------------------------------------------*/
(define (enter-function var)
   (set! *sfun-stack* (cons var *sfun-stack*)))

;*---------------------------------------------------------------------*/
;*    leave-function ...                                               */
;*---------------------------------------------------------------------*/
(define (leave-function)
   (set! *sfun-stack* (cdr *sfun-stack*)))

;*---------------------------------------------------------------------*/
;*    current-function ...                                             */
;*---------------------------------------------------------------------*/
(define (current-function)
   (car *sfun-stack*))
