;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Tools/dsssl.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  SERRANO Manuel                                    */
;*    Creation    :  Thu Apr  3 14:42:11 1997                          */
;*    Last change :  Mon Sep 21 16:49:59 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Some dsssl goodies.                                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_dsssl
   (import tools_error)
   (export (dsssl-named-constant? obj)
	   (dsssl-defaulted-formal? obj)
	   (dsssl-default-formal obj)
	   (dsssl-find-first-formal obj)
	   (dsssl-formals-skeleton obj)
	   (dsssl-formals-encoding obj)
	   (dsssl-args*->args-list obj)))

;*---------------------------------------------------------------------*/
;*    dsssl-named-constant? ...                                        */
;*    -------------------------------------------------------------    */
;*    Is an object a dsssl named constant (#!optional, #!key or        */
;*    #!rest) ?                                                        */
;*---------------------------------------------------------------------*/
(define (dsssl-named-constant? obj)
   ;; this has to be changed after the bootstrap
   (and (cnst? obj)
	(case (cnst->integer obj)
	   ((#x102 #x103 #x106)
	    #t)
	   (else
	    #f))))

;*---------------------------------------------------------------------*/
;*    dsssl-defaulted-formal? ...                                      */
;*    -------------------------------------------------------------    */
;*    Is an expression a defaulted dsssl argument ?                    */
;*---------------------------------------------------------------------*/
(define (dsssl-defaulted-formal? obj)
   (match-case obj
      ((?- ?-)
       #t)
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    dsssl-default-formal ...                                         */
;*    -------------------------------------------------------------    */
;*    The formal of a dsssl-defaulted-formal expression                */
;*---------------------------------------------------------------------*/
(define (dsssl-default-formal obj)
   (car obj))

;*---------------------------------------------------------------------*/
;*    dsssl-find-first-formal ...                                      */
;*---------------------------------------------------------------------*/
(define (dsssl-find-first-formal args)
   (cond
      ((null? args)
       #f)
      ((not (pair? args))
       (internal-error "dsssl-find-first-formal"
		       "Illegal dsssl formal list"
		       args))
      ((dsssl-named-constant? (car args))
       (dsssl-find-first-formal (cdr args)))
      ((dsssl-defaulted-formal? (car args))
       (dsssl-default-formal (car args)))
      ((not (symbol? (car args)))
       (internal-error "dsssl-find-first-formal"
		       "Illegal dsssl formal list"
		       args))
      (else
       (car args))))
       
;*---------------------------------------------------------------------*/
;*    dsssl-formals-skeleton ...                                       */
;*---------------------------------------------------------------------*/
(define (dsssl-formals-skeleton args)
   (let loop ((args args)
	      (skip #f))
      (cond
	 ((null? args)
	  '())
	 ((not (pair? args))
	  args)
	 ((dsssl-named-constant? (car args))
	  (cons (car args) (loop (cdr args) #t)))
	 (skip
	  (loop (cdr args) skip))
	 (else
	  (cons (car args) (loop (cdr args) skip))))))
	 
;*---------------------------------------------------------------------*/
;*    dsssl-formals-encoding ...                                       */
;*---------------------------------------------------------------------*/
(define (dsssl-formals-encoding args)
   (let loop ((args args)
	      (res  '()))
      (cond
	 ((null? args)
	  res)
	 ((not (pair? args))
	  res)
	 ((dsssl-named-constant? (car args))
	  (loop (cdr args) (cons (car args) res)))
	 (else
	  (loop (cdr args) res)))))
	       
;*---------------------------------------------------------------------*/
;*    dsssl-args*->args-list ...                                       */
;*    cons* --> list                                                   */
;*---------------------------------------------------------------------*/
(define (dsssl-args*->args-list exp)
   (cond
      ((null? exp)
       '())
      ((not (pair? exp))
       (list exp))
      ((dsssl-named-constant? (car exp))
       (let ((arg (dsssl-find-first-formal (cdr exp))))
	  (if arg
	      (list arg)
	      '())))
      ((dsssl-defaulted-formal? (car exp))
       (dsssl-args*->args-list (cdr exp)))
      (else
       (cons (car exp) (dsssl-args*->args-list (cdr exp))))))

