;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Tools/args.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 09:49:59 1994                          */
;*    Last change :  Tue Apr  8 15:04:48 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Tools function for managing parameters.                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tools_args
   (import tools_dsssl)
   (export (arity::int exp)
	   (make-args-list args nil cons)
	   (args*->args-list exp)
	   (args-list->args* list arity)
	   (sound-arity?::bool arity args)
	   (make-n-proto n)
	   (+-arity arity <integer>)))

;*---------------------------------------------------------------------*/
;*    arity ...                                                        */
;*    args-list --> int                                                */
;*    -------------------------------------------------------------    */
;*    (lambda n ..)               --> -1                               */
;*    (lambda () ..)              -->  0                               */
;*    (lambda (a1 a2 .. an) ..)   -->  n                               */
;*    (lambda (a1 a2 .. . an) ..) --> -n                               */
;*    -------------------------------------------------------------    */
;*    Any dsssl named constant is equivalent to a `.' expression.      */
;*    Thus:                                                            */
;*    (lambda (a1 a2 .. an-1 #!optional ...#!rest ...) ..) --> -n      */
;*---------------------------------------------------------------------*/
(define (arity args)
   (let loop ((i    0)
	      (args args))
      (cond
	 ((null? args)
	  i)
	 ((pair? args)
	  (if (dsssl-named-constant? (car args))
	      (negfx (+fx i 1))
	      (loop (+fx i 1) (cdr args))))
	 (else
	  (negfx (+fx i 1))))))

;*---------------------------------------------------------------------*/
;*    args*->args-list ...                                             */
;*    cons* --> list                                                   */
;*---------------------------------------------------------------------*/
(define (args*->args-list exp)
   (cond
      ((null? exp)
       '())
      ((not (pair? exp))
       (list exp))
      (else
       (cons (car exp)
             (args*->args-list (cdr exp))))))

;*---------------------------------------------------------------------*/
;*    args-list->args* ...                                             */
;*---------------------------------------------------------------------*/
(define (args-list->args* list arity)
   (cond
      ((>=fx arity 0)
       list)
      ((=fx arity -1)
       (car list))
      (else
       (let loop ((list  list)
		  (arity arity))
	  (if (=fx arity -1)
	      (car list)
	      (cons (car list) (loop (cdr list) (+fx arity 1))))))))
   
;*---------------------------------------------------------------------*/
;*    sound-arity? ...                                                 */
;*---------------------------------------------------------------------*/
(define (sound-arity? arity args)
   (let ((len (length args)))
      (if (>=fx arity 0)
	  (=fx arity len)
	  (<=fx (negfx arity) (+fx len 1)))))

;*---------------------------------------------------------------------*/
;*    make-args-list ...                                               */
;*---------------------------------------------------------------------*/
(define (make-args-list args nil cons)
   (let loop ((args args))
      (if (null? args)
	  nil
	  `(,cons ,(car args) ,(loop (cdr args))))))

;*---------------------------------------------------------------------*/
;*    make-n-proto ...                                                 */
;*    -------------------------------------------------------------    */
;*    On construit un prototype a partir de l'arite.                   */
;*---------------------------------------------------------------------*/
(define (make-n-proto n)
   (define (make-args-name n)
      (string->symbol (string-append "A" (integer->string n))))
   (define (make-va-proto n count)
      (if (=fx n -1)
	  (make-args-name count)
	  (cons (make-args-name count)
		(make-va-proto (+fx n 1) (+fx count 1)))))
   (define (make-fx-proto n count)
      (if (=fx n 0)
	  '()
	  (cons (make-args-name count)
		(make-fx-proto (-fx n 1) (+fx count 1)))))
   (if (<fx n 0)
       (make-va-proto n 0)
       (make-fx-proto n 0)))


;*---------------------------------------------------------------------*/
;*    +-arity ...                                                      */
;*---------------------------------------------------------------------*/
(define (+-arity arity add)
   (if (>=fx arity 0)
       (+fx add arity)
       (-fx arity add)))

       
