;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Reduce/cond.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 13 10:29:17 1995                          */
;*    Last change :  Fri Aug  9 08:25:04 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The conditional reduction                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module reduce_cond
   (include "Tools/trace.sch")
   (import  tools_shape
	    tools_speek
	    tools_error
	    type_type
	    ast_var
	    ast_node)
   (export  (reduce-conditional! globals)))

;*---------------------------------------------------------------------*/
;*    reduce-conditional! ...                                          */
;*---------------------------------------------------------------------*/
(define (reduce-conditional! globals)
   (verbose 2 #"      conditional expression ")
   (for-each (lambda (global)
		(let* ((fun  (global-value global))
		       (node (sfun-body fun))) 
		   (sfun-body-set! fun (node-cond! node))
		   #unspecified))
	     globals)
   (verbose 2 "(reduced : " *cond-reduced* #\) #\newline)
   globals)

;*---------------------------------------------------------------------*/
;*    Statitics ...                                                    */
;*---------------------------------------------------------------------*/
(define *cond-reduced* 0)

;*---------------------------------------------------------------------*/
;*    node-cond! ...                                                   */
;*---------------------------------------------------------------------*/
(define-generic (node-cond!::node node::node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::atom ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::atom)
   node)

;*---------------------------------------------------------------------*/
;*    node-cond! ::kwote ...                                           */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::kwote)
   node)

;*---------------------------------------------------------------------*/
;*    node-cond! ::var ...                                             */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::var)
   node)

;*---------------------------------------------------------------------*/
;*    node-cond! ::closure ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::closure)
   node)

;*---------------------------------------------------------------------*/
;*    node-cond! ::sequence ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::sequence)
   (with-access::sequence node (nodes)
      (node-cond*! nodes)
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::app ...                                             */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::app)
   (with-access::app node (args)
      (node-cond*! args)
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::app-ly ...                                           */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::app-ly)
   (with-access::app-ly node (fun arg)
      (set! fun (node-cond! fun))
      (set! arg (node-cond! arg))
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::funcall ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::funcall)
   (with-access::funcall node (fun args)
      (set! fun (node-cond! fun))
      (node-cond*! args)
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::pragma ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::pragma)
   (with-access::pragma node (args)
      (node-cond*! args)
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::cast ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::cast)
   (with-access::cast node (arg)
      (node-cond! arg)
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::setq ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::setq)
   (with-access::setq node (var value)
      (set! value (node-cond! value))
      (set! var (node-cond! var))
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::conditional ...                                     */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::conditional)
   (with-access::conditional node (test true false)
       (set! test (node-cond! test))
       (set! true (node-cond! true))
       (set! false (node-cond! false))
       (if (atom? test)
	   (begin
	      (set! *cond-reduced* (+fx 1 *cond-reduced*))
	      (trace (reduce 2) "Je reduis le cond: " (shape node) #\Newline)
	      (if (atom-value test)
		  true
		  false))
	   node)))

;*---------------------------------------------------------------------*/
;*    node-cond! ::fail ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::fail)
   (with-access::fail node (type proc msg obj)
      (set! proc (node-cond! proc))
      (set! msg (node-cond! msg))
      (set! obj (node-cond! obj))
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::select ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::select)
   (with-access::select node (clauses test)
      (set! test (node-cond! test))
      (for-each (lambda (clause)
		   (set-cdr! clause (node-cond! (cdr clause))))
		clauses)
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::let-fun ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::let-fun)
   (with-access::let-fun node (body locals)
      (for-each (lambda (local)
		   (let ((fun (local-value local)))
		      (sfun-body-set! fun (node-cond! (sfun-body fun)))))
		locals)
      (set! body (node-cond! body))
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::let-var ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::let-var)
   (with-access::let-var node (body bindings)
      (for-each (lambda (binding)
		   (set-cdr! binding (node-cond! (cdr binding))))
		bindings)
      (set! body (node-cond! body))
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::set-ex-it ...                                       */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::set-ex-it)
   (with-access::set-ex-it node (var body)
      (set! body (node-cond! body))
      (set! var (node-cond! var))
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::jump-ex-it ...                                      */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::jump-ex-it)
   (with-access::jump-ex-it node (exit value)
      (set! exit (node-cond! exit))
      (set! value (node-cond! value))
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::make-box ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::make-box)
   (with-access::make-box node (value)
      (set! value (node-cond! value))
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::box-set! ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::box-set!)
   (with-access::box-set! node (var value)
      (set! var (node-cond! var))
      (set! value (node-cond! value))
      node))

;*---------------------------------------------------------------------*/
;*    node-cond! ::box-ref ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-cond! node::box-ref)
   (with-access::box-ref node (var)
      (set! var (node-cond! var))
      node))

;*---------------------------------------------------------------------*/
;*    node-cond*! ...                                                  */
;*---------------------------------------------------------------------*/
(define (node-cond*! node*)
   (let loop ((node* node*))
      (if (null? node*)
	  'done
	  (begin
	     (set-car! node* (node-cond! (car node*)))
	     (loop (cdr node*))))))

