;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Read/src.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 10:44:03 1994                          */
;*    Last change :  Fri Nov 20 06:53:08 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We read the source file                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module read_src
   (import  read_reader
	    engine_param
	    engine_engine
 	    init_main
	    tools_file)
   (export  (read-src)))

;*---------------------------------------------------------------------*/
;*    read-src ...                                                     */
;*    -------------------------------------------------------------    */
;*    If the first source file start by an expression like             */
;*    #!...                                                            */
;*    we must evaluate the file rather than compile it. Hence,         */
;*    read_src returns `#f' to the compiler which means that the       */
;*    compiler will stop and jump to the interpreter.                  */
;*---------------------------------------------------------------------*/
(define (read-src)
   [assert (*src-files*) (pair? *src-files*)]
   ;; we read the first source file (which must be containing the
   ;; module clause).
   (let ((module (read-module-clause)))
      (if (not (pair? module))
	  module
	  (let loop ((src    (read-src/port))
		     (sfiles (cdr *src-files*)))
	     (if (null? sfiles)
		 (cons module (reverse! src))
		 (loop (read-src-file (car sfiles)) (cdr sfiles)))))))

;*---------------------------------------------------------------------*/
;*    read-handler ...                                                 */
;*---------------------------------------------------------------------*/
(define read-handler
   (lambda (escape proc mes obj)
      ;; before producing the error, we display the
      ;; source file name
      (hello-world)
      ;; then we display the error.
      (notify-error proc mes obj)
      (close-src-port)
      (exit-bigloo -3)))

;*---------------------------------------------------------------------*/
;*    read-module-clause ...                                           */
;*---------------------------------------------------------------------*/
(define (read-module-clause)
   (open-src-file (car *src-files*))
   (let ((module (try (compiler-read *port* #t)
		      read-handler)))
      (if *bigloo-interpreter*
	  ;; the `*bigloo-interpreter* variable is setted by the
	  ;; reader when it seees a #!... expression
	  #f
	  module)))

;*---------------------------------------------------------------------*/
;*    read-src/port ...                                                */
;*---------------------------------------------------------------------*/
(define (read-src/port)
   (let ((port *port*))
      (try (let loop ((r   (compiler-read port #t))
		      (acc '()))
	      (if (eof-object? r)
		  (begin
		     (close-src-port)
		     acc)
		  (loop (compiler-read port #t)
			(cons r acc))))
	   read-handler)))

;*---------------------------------------------------------------------*/
;*    read-src-file ...                                                */
;*---------------------------------------------------------------------*/
(define (read-src-file sfile)
   (open-src-file (find-file/path sfile *load-path*))
   (read-src/port))

;*---------------------------------------------------------------------*/
;*    *port* ...                                                       */
;*---------------------------------------------------------------------*/
(define *port* #f)
		  
;*---------------------------------------------------------------------*/
;*    open-src-file ...                                                */
;*---------------------------------------------------------------------*/
(define (open-src-file sfile)
   (set! *port* (if (string? sfile)
		    (if (file-exists? sfile)
			(let ((port (open-input-file sfile)))
			   (if (input-port? port)
			       (begin
				  (reader-reset!)
				  port)
			       (error "src-file->memory"
				      "Can't open such file"
				      sfile)))
			(error "src-file->memory"
			       "Can't find such file"
			       sfile))
		    (current-input-port))))

;*---------------------------------------------------------------------*/
;*    close-src-port ...                                               */
;*---------------------------------------------------------------------*/
(define (close-src-port)
   (if (and (input-port? *port*)
	    (not (eq? *port* (current-input-port))))
       (close-input-port *port*)))

   
