;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Read/load.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 10:30:51 1994                          */
;*    Last change :  Tue Sep 17 11:54:33 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We scan files in order to find `inline' definitions.             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module read_load
   (include "Tools/trace.sch")
   (import  tools_error
	    tools_speek
	    tools_file
	    type_type
	    ast_ident)
   (export  (load-module module::symbol fnames::pair)))

;*---------------------------------------------------------------------*/
;*    load-module ...                                                  */
;*---------------------------------------------------------------------*/
(define (load-module module fnames)
   (verbose 1 "      [reading loaded module " module "]" #\Newline)
   (let* ((file  (car fnames))
	  (fname (find-file/path file *load-path*)))
      (if (not (string? fname))
	  (user-error "load-module"
		      "Can't find file"
		      fname)
	  (let ((port (open-input-file fname)))
	     (if (not (input-port? port))
		 (user-error "load-module" "Can't open such file" file)
		 (unwind-protect (let ((decl (read port)))
				    (if (not (and (pair? decl)
						  (eq? (car decl) 'module)))
					(user-error
					 "load-module"
					 "Illegal module declaration"
					 decl)
					;; on verifie le nome
					(if (not (eq? (cadr decl) module))
					    (user-error
					     "load-module"
					     (string-append
					      "conflict in module's name: "
					      (symbol->string module) " vs "
					      (symbol->string (cadr decl)))
					     decl))))
				 (close-input-port port))))))
      (for-each loadq fnames))
