;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Read/inline.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 10:30:51 1994                          */
;*    Last change :  Fri Nov 20 06:52:35 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We scan files in order to find `inline' definitions.             */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module read_inline
   (include "Tools/trace.sch"
	    "Ast/unit.sch")
   (import  read_reader
	    tools_error
	    tools_speek
	    tools_shape
	    tools_file
	    ast_ident
	    ast_env
	    type_type
	    ast_var)
   (export  (look-for-inline inline code port fnames module)
	    (inline-finalizer)))

;*---------------------------------------------------------------------*/
;*    look-for-inline ...                                              */
;*    -------------------------------------------------------------    */
;*    We read until we have found all inline definitions or EOF.       */
;*---------------------------------------------------------------------*/
(define (look-for-inline inlines code port fnames module)
   (let loop ((inlines (look-for-inline/exp inlines code module))
	      (exp     (compiler-read port #t))
	      (fnames  fnames)
	      (port    port))
      (cond
	 ((null? inlines)
	  'done)
	 ((eof-object? exp)
	  (if (null? fnames)
	      (user-error "import"
			  "Can't find inline/generic definition(s)"
			  (map car inlines))
	      (let ((fname (find-file/path (car fnames) *load-path*)))
		 (if (not (string? fname))
		     (user-error "import" "Can't find file" (car fnames))
		     (let ((port (open-input-file fname)))
			(unwind-protect (loop inlines
					      (compiler-read port #t)
					      (cdr fnames)
					      port)
					(if (input-port? port)
					    (close-input-port port))))))))
	 (else
	  (loop (look-for-inline/exp inlines exp module)
		(compiler-read port #t)
		fnames
		port)))))

;*---------------------------------------------------------------------*/
;*    look-for-inline/exp ...                                          */
;*---------------------------------------------------------------------*/
(define (look-for-inline/exp inlines exp module)
   (if (null? inlines)
       '()
       (match-case exp
	  ((define-inline (and ?proto (?name . ?-)) . ?body)
	   (let* ((id   (id-of-id name))
		  (cell (assq id inlines)))
	      (if (and (pair? cell) (eq? (cdr cell) 'sifun))
		  (begin
		     (set-car! proto `(@ ,id ,module))
		     (set! *inline-definitions*
			   (cons exp *inline-definitions*))
		     (remq! cell inlines))
		  inlines)))
	  ((begin . ?exp*)
	   (let loop ((inlines inlines)
		      (exp*    exp*))
	      (if (null? exp*)
		  inlines
		  (loop (look-for-inline/exp inlines (car exp*) module)
			(cdr exp*)))))
	  (else
	   inlines))))

;*---------------------------------------------------------------------*/
;*    *inline-definitions* ...                                         */
;*---------------------------------------------------------------------*/
(define *inline-definitions* '())

;*---------------------------------------------------------------------*/
;*    inline-finalizer ...                                             */
;*---------------------------------------------------------------------*/
(define (inline-finalizer)
   (if (null? *inline-definitions*)
       '()
       (list (unit 'imported-inlines 0 *inline-definitions* #t))))

       
     
   
