;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Read/include.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 10:44:03 1994                          */
;*    Last change :  Thu Aug  8 12:06:00 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We read an include file                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module read_include
   (import  engine_param
	    engine_engine
	    tools_speek
	    tools_file
	    tools_error
	    init_main)
   (export  (read-include ::bstring)))

;*---------------------------------------------------------------------*/
;*    read-include ...                                                 */
;*---------------------------------------------------------------------*/
(define (read-include file)
   (let ((cell (include-already-read file)))
      (if (not (pair? cell))
	  (begin
	     (verbose 2 "      [reading include file " file "]" #\Newline)
	     (let ((fname (find-file/path file *load-path*)))
		(if (not (string? fname))
		    (user-error "read-include" "Can't find include file" file)
		    (let ((port (open-input-file fname)))
		       (if (not (input-port? port))
			   (user-error "read-include"
				       "Can't open such file"
				       file)
			   (let ((handler (lambda (escape proc mes obj)
					     (notify-error proc mes obj)
					     (close-input-port port)
					     (exit-bigloo -3))))
			      (try (let* ((first (read port #t))
					  (direc (if (and (pair? first)
							  (eq? (car first)
							       'directives))
						     first
						     '())))
				      (let loop ((aux  (if (pair? direc)
							   (read port #t)
							   first))
						 (sexp '()))
					 (if (eof-object? aux)
					     (let ((r (cons direc
							    (reverse! sexp))))
						(close-input-port port)
						(mark-include-read! file r)
						r)
					     (loop (read port #t)
						   (cons aux sexp)))))
				   handler)))))))
	  (cdr cell))))

;*---------------------------------------------------------------------*/
;*    include-already-read ...                                         */
;*---------------------------------------------------------------------*/
(define (include-already-read file)
   (assoc file *include-read*))

;*---------------------------------------------------------------------*/
;*    mark-include-read! ...                                           */
;*---------------------------------------------------------------------*/
(define (mark-include-read! file what)
   (set! *include-read* (cons (cons file what) *include-read*)))

;*---------------------------------------------------------------------*/
;*    *include-read* ...                                               */
;*---------------------------------------------------------------------*/
(define *include-read* '())
