;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Read/access.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 11:33:41 1993                          */
;*    Last change :  Tue Jun 11 12:01:04 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The module which handle access tables `module/name'              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module read_access
   (import engine_param
	   engine_engine
	   tools_error
	   init_main)
   (export (add-access! module::symbol files::pair)
	   (read-access-file)))

;*---------------------------------------------------------------------*/
;*    add-access! ...                                                  */
;*---------------------------------------------------------------------*/
(define (add-access! module files)
   (let ((b (assq module *access-table*)))
      (if (not b)
	  (set! *access-table* (cons (cons module files) *access-table*))
	  (if (not (equal? (cdr b) files))
	      (warning "add-access!" "access redefinition -- " module)
	      'done))))
	   
;*---------------------------------------------------------------------*/
;*    read-access-file ...                                             */
;*    -------------------------------------------------------------    */
;*    Cette fonction fait des effets de bords sur `*access-table*'     */
;*---------------------------------------------------------------------*/
(define (read-access-file)
   (cond
      ((not (string? *access-file*))
       'done)
      ((not (file-exists? *access-file*))
       (user-error "read-access-file" "Can't find access file" *access-file*))
      (else
       (let ((port (open-input-file *access-file*)))
	  (if (not (input-port? port))
	      (user-error "read-access-file"
			  "Can't open access file"
			  *access-file*)
	      (begin
		 (do-read-access-file port)
		 (close-input-port port)))))))

;*---------------------------------------------------------------------*/
;*    do-read-access-file ...                                          */
;*---------------------------------------------------------------------*/
(define (do-read-access-file port)
   (labels ((handler (escape proc mes obj)
		     (notify-error proc mes obj)
		     (close-output-port port)
		     (exit-bigloo -2)))
      (try (let* ((obj (read port #t))
		  (eof (read port)))
	      (if (not (eof-object? eof))
		  (user-error "read-access-file"
			      "Illegal access file format"
			      eof)
		  (let loop ((obj obj))
		     (if (null? obj)
			 'done
			 (match-case (car obj)
			    (((and (? symbol?) ?m) (and ?f (? string?)) . ?fs)
			     (let loop ((fs     fs)
					(fnames (list f)))
				(cond
				   ((null? fs)
				    (add-access! m (reverse! fnames)))
				   ((string? (car fs))
				    (loop (cdr fs)
					  (cons (car fs) fnames)))
				   (else
				    (user-error "read-access-file"
						"Illegal access file format"
						(car obj)))))
			     (loop (cdr obj)))
			    (else
			     (user-error "read-access-file"
					 "Illegal access file format"
					 (car obj))))))))
	   handler)))
			 
