;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Prof/emit.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  8 17:32:59 1998                          */
;*    Last change :  Fri Dec  4 14:54:29 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The emission of the Bdb identifier translation table.            */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module prof_emit
   (include "Ast/node.sch"
	    "Ast/unit.sch"
	    "Tools/location.sch")
   (import  tools_shape
	    tools_error
	    tools_misc
	    type_env
	    type_cache
	    ast_sexp
	    ast_env
	    ast_ident
	    ast_unit
	    module_module
	    module_include
	    engine_param
	    cgen_prototype)
   (export (emit-prof-info globals ::output-port)))

;*---------------------------------------------------------------------*/
;*    emit-prof-info ...                                               */
;*---------------------------------------------------------------------*/
(define (emit-prof-info globals port)
   ;; the declaration of the association table
   (newline port)
   (newline port)
   (fprint port "/* prof association table */")
   (fprint port "static obj_t write_bprof_table() {")
   (fprint port "   extern obj_t bprof_port;")
   (fprint port "   if( bprof_port == BUNSPEC ) bprof_port = (obj_t)fopen( \""
	   *prof-table-name* "\", \"w\" );")
   (fprint port "   if( bprof_port ) {")
   ;; and then the non function global variables.
   (for-each (lambda (global)
		(if (global-user? global)
		    (let* ((sfun     (global-value global))
			   (clo      (sfun-the-closure sfun)))
		       (set-variable-name! global)
		       (let ((id     (global-id global))
			     (c-name (global-name global)))
			  (fprint port
				  "      fprintf( (FILE *)bprof_port, \"("
				  id " \\\""
				  c-name
				  "\\\")\\n\" );")))))
	     globals)
   (fprint port "   }")
   (fprint port "   return BUNSPEC;")
   (fprint port #"}\n"))

