;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Object/wide-access.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun  5 11:16:50 1996                          */
;*    Last change :  Tue Dec 22 17:26:46 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We make the class accessors                                      */
;*    -------------------------------------------------------------    */
;*    In this module we cannot use consume-module-clause! because      */
;*    the importation are already done.                                */
;*    -------------------------------------------------------------    */
;*    This constructors does not require any importation information   */
;*    since all accessors are always static.                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module object_wide-access
   (include "Object/class.sch"
	    "Tools/trace.sch")
   (import  tools_error
	    tools_misc
	    type_type
	    type_env
	    type_tools
	    type_cache
	    ast_var
	    ast_ident
	    object_class
	    object_struct
	    object_slots
	    object_tools
	    object_access
	    module_module
	    module_impuse
	    engine_param)
   (export  (make-wide-class-accessors! class-def ::type ::obj ::symbol)
	    (import-wide-class-accessors! class-def ::type ::obj ::symbol)))
	     
;*---------------------------------------------------------------------*/
;*    make-wide-class-accessors! ...                                   */
;*---------------------------------------------------------------------*/
(define (make-wide-class-accessors! class-def class src-def import)
   (if (and (class? class) (class? (class-its-super class)))
       (if (correct-wide-class? class src-def)
	   (let* ((super      (class-its-super class))
		  (domestic?  (memq import '(export static)))
		  (sslots     (class-slots super))
		  (slots      (cddr class-def))
		  (cslots     (make-class-slots slots #f src-def))
		  (class-id   (class-id class))
		  (class-name (class-name class))
		  (holder     (class-holder class))
		  (module     (global-module holder))
		  (widening   (class-widening class))
		  (import     (if domestic?
				  import
				  'static)))
	      ;; Now that the class is defined we check the super (is it or
	      ;; not a class).
	      ;; we install the coercion between the new-class and obj
	      ;; and the class and all its super classes.
	      (produce-module-clause! (make-coercion-clause class-id super))
	      [assert (holder) (global? holder)]
	      (class-slots-set! class cslots)
	      ;; we define the coercers for this class
	      (produce-module-clause! `(foreign ,@(make-class-coercers class)))
	      ;; and we build the new definitions
	      (let ((accs (append (make-class-pred! class-id
						    class
						    src-def
						    import)
				  (make-class-makes! 'widening
						     widening
						     class-id
						     class
						     cslots
						     src-def
						     import)
				  (make-wide-class-makes! class-id
							  class
							  cslots
							  sslots
							  src-def
							  import)
				  (make-class-slots-access! class-id
							    super
							    sslots
							    #f
							    src-def
							    import)
				  (make-class-slots-access! class-id
							    class
							    cslots
							    class
							    src-def
							    import))))
		 (cons (make-class-allocate! class-id
					     super
					     holder
					     src-def
					     import)
		       (if domestic?
			   (cons*
			    (make-wide-object->struct class-id
						      class
						      *module*
						      cslots
						      src-def)
			    (make-struct->wide-object class-id
						      class
						      *module*
						      cslots
						      src-def)
			    accs)
			   accs)))))
       '()))

;*---------------------------------------------------------------------*/
;*    import-wide-class-accessors! ...                                 */
;*---------------------------------------------------------------------*/
(define (import-wide-class-accessors! class-def class src-def module)
   (if (and (class? class) (class? (class-its-super class)))
       (if (correct-wide-class? class src-def)
	   (let* ((super      (class-its-super class))
		  (sslots     (class-slots super))
		  (slots      (cddr class-def))
		  (cslots     (make-class-slots slots #f src-def))
		  (class-id   (class-id class))
		  (class-name (class-name class))
		  (holder     (class-holder class))
		  (module     (global-module holder))
		  (widening   (class-widening class)))
	      ;; Now that the class is defined we check the super (is it or
	      ;; not a class).
	      ;; we install the coercion between the new-class and obj
	      ;; and the class and all its super classes.
	      (produce-module-clause! (make-coercion-clause class-id super))
	      [assert (holder) (global? holder)]
	      (class-slots-set! class cslots)
	      ;; we define the coercers for this class
	      (produce-module-clause! `(foreign ,@(make-class-coercers class)))
	      ;; and we build the new importatations
	      (import-class-pred! class-id class src-def module)
	      (import-class-makes! widening class-id class
				   cslots src-def module)
	      (import-wide-class-makes! class-id class cslots
					sslots src-def module)
	      (import-class-slots-access! class-id super
					  sslots src-def module)
	      (import-class-slots-access! class-id class
					  cslots src-def module))))
   '())
   
;*---------------------------------------------------------------------*/
;*    correct-wide-class? ...                                          */
;*    -------------------------------------------------------------    */
;*    This function checks that the super class is conform to the      */
;*    class. That is, the class is a wide class and the super          */
;*    class is final.                                                  */
;*---------------------------------------------------------------------*/
(define (correct-wide-class? class src-def)
   (let* ((super      (class-its-super class))
	  (class-id   (class-id class)))
	  ;; Now that the class is defined we check the super (is it or
	  ;; not a class).
      (cond
	 ((and (type? super) (not (class? super)))
	  (user-error (type-id super)
		      (string-append "super of `"
				     (symbol->string class-id)
				     "' is not a class")
		      src-def
		      type))
	 ((not (wide-class? class))
	      ;; internal error because plain classes must be processed
	      ;; by make-class-accesses
	  (internal-error "make-wide-class-accesses!"
			  "Should not be able to see a plain class here"
			  src-def))
	 ((wide-class? super)
	      ;; no one can inherite of a wide class
	  (user-error (type-id super)
		      (string-append "super of `"
				     (symbol->string class-id)
				     "' is a wide class")
		      src-def
		      type))
	 ((not (final-class? super))
	      ;; wide class can only inherit of final classes
	  (user-error (type-id super)
		      (string-append "super of wide class `"
				     (symbol->string class-id)
				     "' is not a final class")
		      src-def
		      type))
	 ((final-class? class)
	      ;; a class can't be final and wide
	  (user-error class-id
		      "A class can't be `wide' and `final'"
		      src-def
		      type))
	 (else
	  #t))))

;*---------------------------------------------------------------------*/
;*    make-wide-class-makes! ...                                       */
;*---------------------------------------------------------------------*/
(define (make-wide-class-makes! id type slots sslots src-def import)
   (let ((mk-heap-id  (symbol-append 'make- id))
	 (mk-stack-id (symbol-append 'make-stack- id)))
      (if (or (<fx *optim* 2) (not *optim-stack?*))
	  (list (make-wide-class-make! '- id type slots sslots src-def import))
	  (begin
	     (produce-module-clause!
	      `(pragma (,mk-heap-id (stack-alloc ,mk-stack-id))))
	     (list
	      (make-wide-class-make! '- id type slots
				     sslots src-def import)
	      (make-wide-class-make! '-stack- id type slots
				     sslots src-def import))))))

;*---------------------------------------------------------------------*/
;*    make-wide-class-make! ...                                        */
;*---------------------------------------------------------------------*/
(define (make-wide-class-make! mk-region id type slots sslots src-def import)
   (let* ((super       (class-its-super type))
	  (holder      (class-holder type))
	  (constrs     (find-class-constructors type))
	  (tid         (type-id type))
	  (stid        (type-id super))
	  (mk-tid      (symbol-append 'make mk-region id 4dots tid))
	  (f-ids       (make-class-make-formals slots))
	  (sf-ids      (make-class-make-formals sslots))
	  (f-tids      (make-class-make-typed-formals slots))
	  (sf-tids     (make-class-make-typed-formals sslots))
	  (widening    (symbol-append (class-widening type)
				      mk-region
				      (type-id type)))
	  (aux         (gensym 'aux))
	  (new         (gensym 'new))
	  (mk-class-id (symbol-append 'make mk-region stid)))
      ;; the module clause of the maker
      (produce-module-clause!
       `(,import
	 (,@(if (>=fx *optim* 2) '(inline) '()) ,mk-tid ,@sf-tids ,@f-tids)))
      ;; the definition of the maker
      (epairify `(,(if (>=fx *optim* 2) 'define-inline 'define)
		 (,mk-tid ,@sf-tids ,@f-tids)
		 ;; we make the allocation in several times:
		 ;; 1- we allocate a super object ...
		 (let ((,(symbol-append aux 4dots stid)
			(,mk-class-id ,@sf-ids)))
		    ;; 2- we create a variable of type type aliased
		    ;; to the super object ...
		    (let ((,(symbol-append new 4dots tid)
			   (,(symbol-append 'free-pragma 4dots tid)
			    ,(string-append "((" (type-name type) ")($1))")
			    ,aux)))
		       ;; 3- we set the class number of the new object ...
		       (object-class-num-set!
			,new
			(class-num (@ ,(global-id holder)
				      ,(global-module holder))))
		       ;; 4- we set the widening property ...
		       (object-widening-set! ,new (,widening ,@f-ids))
		       ;; 5- if there is a constructor for that
		       ;; object we call it
		       ,@(if (and (pair? constrs)
				   (not (eq? widening 'widening)))
			      (map (lambda (constr)
				       `(,constr ,new))
				   constrs)
			      '())
		       ;; 6- we return the object
		       ,new)))
	       src-def)))

;*---------------------------------------------------------------------*/
;*    import-wide-class-makes! ...                                     */
;*---------------------------------------------------------------------*/
(define (import-wide-class-makes! id type slots sslots src-def module)
   (let ((mk-heap-id  (symbol-append 'make- id))
	 (mk-stack-id (symbol-append 'make-stack- id)))
      (list (import-wide-class-make! '- id type slots sslots src-def module))))

;*---------------------------------------------------------------------*/
;*    import-wide-class-make! ...                                      */
;*---------------------------------------------------------------------*/
(define (import-wide-class-make! mk-region id type slots sslots src-def module)
   (let* ((tid     (type-id type))
	  (mk-tid  (symbol-append 'make mk-region id 4dots tid))
	  (f-tids  (map (lambda (slot)
			   (symbol-append
			    (slot-id slot)
			    4dots
			    (type-id (slot-type slot))))
			slots))
	  (sf-tids (map (lambda (slot)
			   (symbol-append
			    (slot-id slot)
			    4dots
			    (type-id (slot-type slot))))
			sslots)))
      ;; the module clause of the importation
      (import-parser module `(,mk-tid ,@sf-tids ,@f-tids))))
