;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Object/slots.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 18 12:48:07 1996                          */
;*    Last change :  Fri Dec 18 17:23:25 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We build the class slots                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module object_slots
   (include "Object/class.sch")
   (import  tools_error
	    type_type
	    type_cache
	    ast_var
	    ast_ident
	    object_class
	    engine_param)
   (export  (make-class-slots ::obj ::obj ::obj)))

;*---------------------------------------------------------------------*/
;*    ensure-type-defined! ...                                         */
;*---------------------------------------------------------------------*/
(define (ensure-type-defined! type::type src)
   (if (not (type-init? type))
       (user-error "Can't find type definition" (type-id type) src)))

;*---------------------------------------------------------------------*/
;*    make-class-slots ...                                             */
;*---------------------------------------------------------------------*/
(define (make-class-slots slots super src)
   (define (find-default-attr attr)
      (if (not (pair? attr))
	  '(#f . #unspecified)
	  (match-case (car attr)
	     ((default ?value)
	      (cons #t value))
	     (else
	      (find-default-attr (cdr attr))))))
   (define (find-assert-attr attr)
      (if (not (pair? attr))
	  #f
	  (match-case (car attr)
	     ((assert ((? symbol?)) ?value)
	      (set-car! (car attr) 'lambda)
	      (car attr))
	     (else
	      (find-assert-attr (cdr attr))))))
   (define (find-virtual-attr attr)
      (let loop ((attr attr)
		 (get  #f)
		 (set  #f))
	 (if (not (pair? attr))
	     (cons get set)
	     (match-case (car attr)
		((get ?get)
		 (loop (cdr attr) get set))
		((set ?set)
		 (loop (cdr attr) get set))
		(else
		 (loop (cdr attr) get set))))))
   (define (find-set-attr attr)
      (if (not (pair? attr))
	  '(#f . #unspecified)
	  (match-case (car attr)
	     ((set ?value)
	      (cons #t value))
	     (else
	      (find-default-attr (cdr attr))))))
   (define (slot-member? slot slot-list)
      ;; this function returns true if there is a slot with the same name
      ;; in the list
      (let ((id (slot-id slot)))
	 (let loop ((slot-list slot-list))
	    (cond
	       ((null? slot-list)
		#f)
	       ((eq? (slot-id (car slot-list)) id)
		#t)
	       (else
		(loop (cdr slot-list)))))))
   (define (unique-virtual-slots slots)
      ;; this function removes overriden duplicate slots
      (let loop ((slots slots)
		 (res   '()))
	 (cond
	    ((null? slots)
	     res)
	    ((and (slot-virtual? (car slots)) (slot-member? (car slots) res))
	     (loop (cdr slots) res))
	    (else
	     (loop (cdr slots) (cons (car slots) res))))))
   (let loop ((slots slots)
	      (res   (cond
			((not (type? super))
			 '())
			((not (class? super))
			 '())
			(else
			 ;; take care to the double reverse. Here we can't
			 ;; do in in-place reverse otherwise will be destroying
			 ;; super classes fields. This reverse allocates
			 ;; a fresh slots list.
			 (reverse (class-slots super))))))
      (if (null? slots)
	  (unique-virtual-slots res)
	  (let ((s (car slots)))
	     (match-case s
		((* (id ?slot-id) . ?attr)
		 (let ((id      (symbol-append (car slot-id) '-len))
		       (default (find-default-attr attr))
		       (a-exp   (find-assert-attr attr))
		       (virtual (find-virtual-attr attr))
		       (type    (if (eq? (cdr slot-id) *_*)
				    *obj*
				    (cdr slot-id))))
		    (ensure-type-defined! type src)
		    (if (or (car virtual) (cdr virtual))
			(user-error "Parse error"
				    "virtual slot can't be indexed"
				    s
				    '()))
		    (loop (cdr slots)
			  (cons (slot (car slot-id)
				      (scheme-symbol->c-string (car slot-id))
				      type
				      #f
				      #unspecified
				      #t
				      #f
				      (memq 'read-only attr)
				      (car default)
				      (cdr default)
				      a-exp
				      #f
				      #f
				      #f
				      s)
				(cons 
				 (slot id
				       (scheme-symbol->c-string id)
				       *long*
				       #f
				       #unspecified
				       #f
				       #t
				       #t
				       #f
				       #unspecified
				       #f
				       #f
				       #f
				       #f
				       s)
				 res)))))
		((+ ?len (id ?slot-id) . ?attr)
		 (let ((id      (symbol-append (car slot-id) '-len))
		       (default (find-default-attr attr))
		       (a-exp   (find-assert-attr attr))
		       (virtual (find-virtual-attr attr))
		       (type    (if (eq? (cdr slot-id) *_*)
				    *obj*
				    (cdr slot-id))))
		    (ensure-type-defined! type src)
		    (if (or (car virtual) (cdr virtual))
			(user-error "Parse error"
				    "virtual slot can't be indexed"
				    s
				    '()))
		    (loop (cdr slots)
			  (cons (slot (car slot-id)
				      (scheme-symbol->c-string (car slot-id))
				      type
				      #t
				      len
				      #f
				      #f
				      (memq 'read-only attr)
				      (car default)
				      (cdr default)
				      a-exp
				      #f
				      #f
				      #f
				      s)
				res))))
		(((id ?slot-id) . ?attr)
		 (let ((default (find-default-attr attr))
		       (a-exp   (find-assert-attr attr))
		       (virtual (find-virtual-attr attr))
		       (reado?  (memq 'read-only attr))
		       (type    (if (eq? (cdr slot-id) *_*)
				    *obj*
				    (cdr slot-id))))
		    (cond
		       ((and (cdr virtual) (not (car virtual)))
			(user-error "Parse error"
				    "illegal virtual slot (missing getter)"
				    s
				    '()))
		       ((and (car virtual) (cdr virtual) reado?)
			(user-error "Parse error"
				    "illegal virtual slot (read-only)"
				    s
				    '()))
		       ((and (car virtual) (not (cdr virtual)) (not reado?))
			(user-error "Parse error"
				    "illegal virtual slot (missing setter)"
				    s
				    '())))
		    (ensure-type-defined! type src)
		    (loop (cdr slots)
			  (cons (slot (car slot-id)
				      (scheme-symbol->c-string (car slot-id))
				      type
				      #f
				      #unspecified
				      #f
				      #f
				      reado?
				      (car default)
				      (cdr default)
				      a-exp
				      (or (car virtual) (cdr virtual))
				      (car virtual)
				      (cdr virtual)
				      s)
				res))))
		((id ?slot-id)
		 (let ((type (if (eq? (cdr slot-id) *_*)
				 *obj*
				 (cdr slot-id))))
		    (ensure-type-defined! type src)
		    (loop (cdr slots)
			  (cons (slot (car slot-id)
				      (scheme-symbol->c-string (car slot-id))
				      type
				      #f
				      #unspecified
				      #f
				      #f
				      #f
				      #f
				      #unspecified
				      #f
				      #f
				      #f
				      #f
				      s)
				res))))
		(else
		 (user-error "Parse error"
			     "Unknown class slot type"
			     s
			     '())))))))

;*---------------------------------------------------------------------*/
;*    scheme-symbol->c-string ...                                      */
;*---------------------------------------------------------------------*/
(define (scheme-symbol->c-string symbol)
   (if *case-sensitive*
       (id->name symbol)
       (string-downcase (id->name symbol))))
