;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Object/plain-access.scm     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun  5 11:16:50 1996                          */
;*    Last change :  Sun Dec 13 10:27:21 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We make the class accessors                                      */
;*    -------------------------------------------------------------    */
;*    In this module we cannot use consume-module-clause! because      */
;*    the importation are already done.                                */
;*    -------------------------------------------------------------    */
;*    This constructors does not require any importation information   */
;*    since all accessors are always static.                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module object_plain-access
   (include "Object/class.sch"
	    "Tools/trace.sch")
   (import  tools_error
	    tools_misc
	    type_type
	    type_env
	    type_tools
	    type_cache
	    ast_var
	    ast_ident
	    object_class
	    object_struct
	    object_slots
	    object_tools
	    object_access
	    module_module
	    module_impuse
	    engine_param)
   (export  (make-plain-class-accessors!   class-def ::type ::obj ::symbol)
	    (import-plain-class-accessors! class-def ::type ::obj ::symbol)))

;*---------------------------------------------------------------------*/
;*    make-plain-class-accessors! ...                                  */
;*---------------------------------------------------------------------*/
(define (make-plain-class-accessors! class-def class src-def import)
   (trace (ast 2) "make-plain-class-accessors!: " src-def #\Newline)
   ;; we first check that the class is correctly defined
   (if (correct-plain-class? class src-def)
       (let* ((super      (class-its-super class))
	      (domestic?  (memq import '(export static)))
	      (slots      (cddr class-def))
	      (cslots     (make-class-slots slots
					    (if (eq? super class) #f super)
					    src-def))
	      (class-id   (class-id class))
	      (class-name (class-name class))
	      (holder     (class-holder class))
	      (import     (if domestic?
			      import
			      'static)))
	  ;; we install the coercion between the new-class and obj
	  ;; and the class and all its super classes.
	  (produce-module-clause! (make-coercion-clause class-id super))
	  [assert (holder) (global? holder)]
	  (class-slots-set! class cslots)
	  ;; we define the coercers for this class
	  (produce-module-clause! `(foreign ,@(make-class-coercers class)))
	  ;; and we build the new definitions
	  (let ((accs (append (make-class-pred! class-id
						class
						src-def
						import)
			      (make-class-makes! 'make
						 'make
						 class-id
						 class
						 cslots
						 src-def
						 import)
			      (make-class-slots-access! class-id
							class
							cslots
							#f
							src-def
							import))))
	     (cons (make-class-allocate! class-id class holder src-def import)
		   (if (type? (class-its-super class))
		       (if domestic?
			   (cons*
			    (make-object->struct class-id
						 class
						 *module*
						 cslots
						 src-def)
			    (make-struct->object class-id
						 class
						 *module*
						 cslots
						 src-def)
			    accs)
			   accs)
		       accs))))
	  '()))
	  
;*---------------------------------------------------------------------*/
;*    import-plain-class-accessors! ...                                */
;*---------------------------------------------------------------------*/
(define (import-plain-class-accessors! class-def class src-def module)
   (trace (ast 2) "impport-plain-class-accessors!: " src-def #\Newline)
      ;; we first check that the class is correctly defined
   (if (correct-plain-class? class src-def)
       (let* ((super      (class-its-super class))
	      (slots      (cddr class-def))
	      (cslots     (make-class-slots slots
					    (if (eq? super class) #f super)
					    src-def))
	      (class-id   (class-id class))
	      (class-name (class-name class))
	      (holder     (class-holder class)))
	  ;; we install the coercion between the new-class and obj
	  ;; and the class and all its super classes.
	  (produce-module-clause! (make-coercion-clause class-id super))
	  [assert (holder) (global? holder)]
	  (class-slots-set! class cslots)
	  ;; we define the coercers for this class
	  (produce-module-clause! `(foreign ,@(make-class-coercers class)))
	  ;; and we build the new importations
	  (import-class-pred! class-id class src-def module)
	  (import-class-makes! 'make class-id class cslots src-def module)
	  (import-class-slots-access! class-id class cslots src-def module)))
   '())
	  
;*---------------------------------------------------------------------*/
;*    correct-plain-class? ...                                         */
;*    -------------------------------------------------------------    */
;*    This function checks that the super class is conform to the      */
;*    class. That is, the class is not a wide class and the super      */
;*    class is not final.                                              */
;*---------------------------------------------------------------------*/
(define (correct-plain-class? class src-def)
   (let ((super    (class-its-super class))
	 (class-id (class-id class)))
      ;; Now that the class is defined we check the super (is it or
      ;; not a class).
      (cond
	 ((and (type? super) (not (class? super)))
	  (user-error (type-id super)
		      (string-append "super of `"
				     (symbol->string class-id)
				     "' is not a class")
		      src-def
		      type)
	  #f)
	 ((wide-class? class)
	  ;; internal error because wide classes must be processed
	  ;; by make-wide-class-accesses
	  (internal-error "make-class-accesses!"
			  "Should not be able to see a wide class here"
			  src-def)
	  #f)
	 ((wide-class? super)
	  ;; no one can inherite of a wide class
	  (user-error (type-id super)
                      (string-append "super of `"
                                     (symbol->string class-id)
                                     "' is a wide class")
                      src-def
		      type)
	  #f)
	 ((final-class? super)
	  ;; only wide class can inherit of final classes
	  (user-error (type-id super)
                      "Only wide classes can inherit of final classes" 
                      src-def
		      type)
	  #f)
	 (else
	  #t))))


