;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Object/method.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed May  1 13:58:40 1996                          */
;*    Last change :  Sun May 17 17:33:18 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The method management                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module object_method
   (import tools_args
	   tools_error
	   tools_misc
	   type_type
	   ast_var
	   ast_ident
	   ast_env
	   object_class
	   object_inline)
   (export (make-method-body ::symbol ::obj ::obj ::obj ::obj)))

;*---------------------------------------------------------------------*/
;*    make-method-body ...                                             */
;*---------------------------------------------------------------------*/
(define (make-method-body id args locals body src)
   (let* ((id      (id-of-id id))
	  (method  (gensym 'next-method))
	  (arity   (arity args))
	  (args-id (map local-id locals))
	  (type    (local-type (car locals)))
	  ;; The name of the method is constructed using the id of the
	  ;; associated generic function _and_ the type id of the
	  ;; method.
	  (m-id    (symbol-append id '- (type-id type))))
      (if (not (class? type))
	  (method-error id "method has a non-class dispatching type arg" src)
	  (let* ((holder  (class-holder type))
		 (module  (global-module holder))
		 (generic (find-global id)))
	     (cond
		((not (global? generic))
		 (method-error id "Can't find generic for method" src))
		((or (not (method-inlining-enabled?))
		     (eq? (global-import generic) 'import))
		 (let* ((body `(labels ((call-next-method ()
				   (let ((,method (find-super-class-method
						   ,(car args-id)
						   ,id
						   (@ ,(global-id holder)
						      ,module))))
				      (if (procedure? ,method)
					  ,(if (>=fx arity 0)
					       `(,method ,@args-id)
					       `(apply ,method
						       (cons* ,@args-id)))
					  (begin
					     (generic-pre-method-set! ,id
								      ,method)
					     ,(if (>=fx arity 0)
						  `(,id ,@args-id)
						  `(apply
						    ,id
						    (cons* ,@args-id))))))))
						,body))
			(ebody (if (epair? src)
				   (econs (car body) (cdr body) (cer src))
				   body))
			(bdg   `(,m-id ,args ,ebody))
			(ebdg  (if (epair? src)
				   (econs (car bdg) (cdr bdg) (cer src))
				   bdg)))
		    (list `(labels (,ebdg)
			      (add-method! ,id
					   (@ ,(global-id holder) ,module)
					   ,m-id)))))
		(else
		 ;; in all the case the call `add-generic-method-inlining!'
		 ;; if the generic has already been added, this call will
		 ;; be nop equivalent.
		 (add-generic-for-method-inlining! generic)
		 ;; and now we add the method definition.
		 (let ((num (add-generic-method! generic type args body)))
		    (list `(add-inlined-method!
			    ,id
			    (@ ,(global-id holder) ,module)
			    ,num)))))))))
 
;*---------------------------------------------------------------------*/
;*    method-error ...                                                 */
;*---------------------------------------------------------------------*/
(define (method-error id msg src)
   (user-error id msg src (list ''method-definition-error)))
