;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Object/inline.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul 16 10:39:37 1996                          */
;*    Last change :  Wed Aug 21 11:06:29 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This module implements an optimization about the method dispatch.*/
;*    The optimization consists of an entire scan of all the program   */
;*    text. It operates the following source to source transformation  */
;*    for generic functions which are defined in the current module.   */
;*                                                                     */
;*    (define-generic (foo x y) body)                                  */
;*                                                                     */
;*    (define-method (foo x::c1 y) body1)                              */
;*                                                                     */
;*    (define-method (foo x::c2 y) body2)                              */
;*                                                                     */
;*     ==>                                                             */
;*                                                                     */
;*    (define-generic (foo x y)                                        */
;*       (let ((m (find-method foo x)))                                */
;*          (case m                                                    */
;*            ((m1) body1)                                             */
;*            ((m2) body2)                                             */
;*            (else                                                    */
;*              ...))))                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module object_inline
   (include "Tools/trace.sch")
   (import  engine_param
	    tools_shape
	    tools_speek
	    tools_args
	    type_type
	    expand_eps
	    ast_var
	    ast_node
	    ast_sexp
	    object_class)
   (export  (method-inlining-enabled?::bool)
	    (inline-methods!)
	    (add-generic-for-method-inlining! generic)
	    (add-generic-method!::long generic::global type::type args body)))

;*---------------------------------------------------------------------*/
;*    method-inlining-enabled? ...                                     */
;*---------------------------------------------------------------------*/
(define (method-inlining-enabled?)
   *optim-inline-method?*)

;*---------------------------------------------------------------------*/
;*    disable-method-inlining! ...                                     */
;*---------------------------------------------------------------------*/
(define (disable-method-inlining!)
   (set! *intern-generic* '())
   (set! *optim-inline-method?* #f))

;*---------------------------------------------------------------------*/
;*    add-generic-for-method-inlining! ...                             */
;*---------------------------------------------------------------------*/
(define (add-generic-for-method-inlining! generic)
   (if (and (method-inlining-enabled?)
	    (not (pair? (assq generic *intern-generic*))))
       (set! *intern-generic* (cons (cons generic (cons 0 '()))
				    *intern-generic*))))

;*---------------------------------------------------------------------*/
;*    *intern-generic* ...                                             */
;*---------------------------------------------------------------------*/
(define *intern-generic* '())

;*---------------------------------------------------------------------*/
;*    imethod ...                                                      */
;*---------------------------------------------------------------------*/
(define-struct imethod args body num)

;*---------------------------------------------------------------------*/
;*    add-generic-method! ...                                          */
;*---------------------------------------------------------------------*/
(define (add-generic-method! generic type args body)
   (let ((cell (assq generic *intern-generic*)))
      [assert (cell) (pair? cell)]
      (let ((num (cadr cell)))
	 (set-car! (cdr cell) (+fx num 1))
	 (set-cdr! (cdr cell) (cons (imethod args body num) (cddr cell)))
	 num)))

;*---------------------------------------------------------------------*/
;*    inline-methods! ...                                              */
;*---------------------------------------------------------------------*/
(define (inline-methods!)
   (if (and (method-inlining-enabled?) (pair? *intern-generic*))
       (begin
	  (verbose 1 "   . Method inlining" #\newline)
	  (for-each inline-method! *intern-generic*)
	  (disable-method-inlining!))))

;*---------------------------------------------------------------------*/
;*    inline-method! ...                                               */
;*---------------------------------------------------------------------*/
(define (inline-method! cell)
   (let* ((generic    (car cell))
	  (imethods   (reverse! (cddr cell)))
	  (sfun       (global-value generic))
	  (tres       (global-type generic))
	  (old-body   (sfun-body sfun))
	  (args       (sfun-args sfun))
	  (arity      (sfun-arity sfun))
	  (marg       (car args))
	  (method     (gensym 'method))
	  (loop       (gensym 'loop))
	  (super      (gensym 'super))
	  (aux        (gensym 'aux))
	  (larg       (gensym 'larg))
	  (largs      (cons larg (cdr args)))
	  (other-body `(if (procedure? ,method)
			   ,(if (>=fx arity 0)
				`(,method ,@args)
				`(apply ,method (cons* ,@args)))
			   ,old-body))
	  (class      (gensym 'class)))
      (let ((new-body
	     (comptime-expand
	      `(letrec ((,loop (lambda (,method ,class)
				  (let ((call-next-method
					 (lambda ()
					    (let* ((,super (if (class? ,class)
							       (class-super
								,class)
							       #f))
						   (,aux   (find-method-from
							    ,marg
							    ,generic
							    ,super)))
					       (,loop (cdr ,aux)
						      (car ,aux))))))
				     (case ,method
					,@(make-case-clauses args imethods)
					(else
					 ,other-body))))))
		  ,(if (class? (local-type marg))
		       `(,loop (find-inline-method ,marg ,generic)
			       (object-class ,marg))
		       `(if (object? ,marg)
			    (,loop (find-inline-method ,marg ,generic)
				   (object-class ,marg))
			    (,loop #f #f)))))))
	 (sfun-body-set! sfun (sexp->node new-body
					  args
					  (node-loc old-body)
					  'value)))))

;*---------------------------------------------------------------------*/
;*    make-case-clauses ...                                            */
;*---------------------------------------------------------------------*/
(define (make-case-clauses args imethods)
   (map (lambda (imethod) (inline-method-clause args imethod)) imethods))

;*---------------------------------------------------------------------*/
;*    inline-method-clause ...                                         */
;*---------------------------------------------------------------------*/
(define (inline-method-clause generic-args imethod)
   (let ((args (imethod-args imethod))
	 (num  (imethod-num imethod))
	 (body (imethod-body imethod)))
      `((,num) (let ,(map list (args*->args-list args) generic-args) ,body))))

