;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Object/class.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu May 30 16:46:40 1996                          */
;*    Last change :  Fri Dec 25 14:25:07 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The class definition                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module object_class

   (include "Object/class.sch")
   
   (import  tools_error
	    type_type
	    type_cache
	    type_env
	    object_tools
	    module_module
	    engine_param
	    ast_var
	    ast_ident)

   (export  (wide-class class::type
	       ;; the `super' field
	       its-super
	       ;; the slots of the class
	       (slots (default #unspecified))
	       ;; a global variable holding the class info
	       (holder::global read-only)
	       ;; widening
	       (widening (default #f) read-only)
	       ;; the depth of the class in the inheritance tree
	       (depth::long (default 0))
	       ;; final
	       (final?::bool read-only (default #f))
	       ;; constructor
	       (constructor read-only))

	    (heap-add-class!           ::class)
	    (declare-class-type!::type ::obj ::global ::obj ::bool ::obj)
	    (emit-class-types          ::output-port)
	    (final-class?::bool        ::obj)
	    (wide-class?::bool         ::obj)
	    (find-class-constructors   ::class)
	    (type-subclass?::bool      ::type ::type)))

;*---------------------------------------------------------------------*/
;*    *class-type-list* ...                                            */
;*---------------------------------------------------------------------*/
(define *class-type-list* '())

;*---------------------------------------------------------------------*/
;*    heap-add-class! ...                                              */
;*    -------------------------------------------------------------    */
;*    This function is to be used when restoring class from a heap     */
;*    file.                                                            */
;*---------------------------------------------------------------------*/
(define (heap-add-class! type::class)
   (set! *class-type-list* (cons type *class-type-list*)))
   
;*---------------------------------------------------------------------*/
;*    declare-class-type! ...                                          */
;*    -------------------------------------------------------------    */
;*    declare-class-type! is said to be returning a type and not       */
;*    a class in order to help the error management.                   */
;*    -------------------------------------------------------------    */
;*    No check is processed in this function about the super class.    */
;*    This check is performed by the function that creates the         */
;*    accessors for the class (make-class-accesses! and make-wide      */
;*    -class-accesses of the module object_access).                    */
;*---------------------------------------------------------------------*/
(define (declare-class-type!::type class-def class-holder widening final? src)
   (let* ((class-ident (parse-id (car class-def)))
	  (class-id    (car class-ident))
	  (super       (let ((super (cdr class-ident)))
			  (cond
			     ((eq? (type-id super) class-id)
			      #f)
			     ((eq? super *_*)
			      (get-object-type))
			     (else
			      super))))
	  (name        (if *case-sensitive*
			   (id->name class-id)
			   (string-downcase (id->name class-id))))
	  (sizeof      (string-append "struct " name))
	  (t-name      (string-append name "_t"))
	  (type        (declare-type! class-id t-name 'bigloo)))
      ;; By now we make the assumption that super is a correct class.
      ;; Super will be checked in `make-class-accesses!' (see module
      ;; object_access).
      (widen!::class type
	 (its-super   super)
	 (depth       (if (not (class? super))
			  0
			  (+fx (class-depth super) 1)))
	 (holder      class-holder)
	 (widening    widening)
	 (final?      final?)
	 (constructor (cadr class-def)))
      ;; we set the sizeof field
      (type-size-set!  type sizeof)
      ;; we add the class for the C type emission
      (set! *class-type-list* (cons type *class-type-list*))
      ;; we are done
      type))

;*---------------------------------------------------------------------*/
;*    cross-name ...                                                   */
;*    -------------------------------------------------------------    */
;*    This function return the typedef name for non class objects      */
;*    and the `struct ??? *' name for classes. We need this function   */
;*    because C does not support cross typedefed references.           */
;*---------------------------------------------------------------------*/
(define (cross-name type)
   (if (class? type)
       (string-append (type-size type) " *")
       (type-name type)))

;*---------------------------------------------------------------------*/
;*    emit-class-types ...                                             */
;*---------------------------------------------------------------------*/
(define (emit-class-types oport)
   (if (pair? *class-type-list*)
       (fprint oport #\Newline "/* Object type definitions */"))
   (for-each (lambda (class)
		(if (not (eq? class (get-object-type)))
		    (begin
		       (fprint oport "typedef " (type-size class) " {")
		       (if (not (class-widening class))
			   (begin
			      (fprint oport "   header_t header;")
			      (fprint oport "   obj_t    widening;"))
			   (if (null? (class-slots class))
			       ;; this is an empty object (with no fields)
			       ;; and some ISO C compilers (is it in the
			       ;; definition ?) does not support empty types.
			       ;; Hence, we generate a dummy field as
			       ;; small as possible.
			       (fprint oport "   char dummy;")))
		       (for-each (lambda (slot)
				    (let ((name (cross-name (slot-type slot))))
				       (if (not (slot-virtual? slot))
					   (cond
					      ((slot-dyna-indexed? slot)
					       (fprint oport
						       "   "
						       name
						       " *"
						       (slot-name slot)
						       ";"))
					      ((slot-stat-indexed? slot)
					       (fprint oport
						       "   "
						       name
						       " "
						       (slot-name slot)
						       "[ "
						       (slot-stat-bound slot)
						       " ]"
						       ";"))
					      (else
					       (fprint oport
						       "   "
						       name
						       " "
						       (slot-name slot)
						       ";"))))))
				 (class-slots class))
		       (fprint oport "} *" (type-name class) #";\n"))))
	     (reverse! *class-type-list*))
   (if (pair? *class-type-list*)
       (newline oport)))

;*---------------------------------------------------------------------*/
;*    final-class? ...                                                 */
;*    -------------------------------------------------------------    */
;*    Is a class a final class ?                                       */
;*---------------------------------------------------------------------*/
(define (final-class? class)
   (and (class? class) (class-final? class)))

;*---------------------------------------------------------------------*/
;*    wide-class? ...                                                  */
;*    -------------------------------------------------------------    */
;*    Is a class a wide-class ?                                        */
;*---------------------------------------------------------------------*/
(define (wide-class? class)
   (and (class? class) (class-widening class)))

;*---------------------------------------------------------------------*/
;*    type-subclass? ...                                               */
;*---------------------------------------------------------------------*/
(define (type-subclass? subclass class)
   (cond
      ((not (class? class))
       #f)
      ((not (class? subclass))
       #f)
      (else
       (let loop ((subclass subclass))
	  (cond
	     ((eq? subclass class)
	      #t)
	     ((not (class? subclass))
	      #f)
	     ((eq? (class-its-super subclass) subclass)
	      #f)
	     (else
	      (loop (class-its-super subclass))))))))

;*---------------------------------------------------------------------*/
;*    find-class-constructors ...                                      */
;*    -------------------------------------------------------------    */
;*    I just don't know what to do here. i) Shall we invoke the        */
;*    all constructors (a la C++). ii) Shall we call the first         */
;*    constructor defined? iii) Shall we call the constructor          */
;*    if it exists? For now I have chosen ii) because it fits the need */
;*    for all the code I have currently that make use of constructors. */
;*---------------------------------------------------------------------*/
(define (find-class-constructors class::class)
   (let loop ((class class))
      (with-access::class class (constructor its-super)
	 (cond
	    ((or (not (class? class)) (eq? class its-super))
	     '())
	    (constructor
	     (list constructor))
	    (else
	     (loop its-super))))))
