;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Object/class.sch            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun  5 11:28:23 1996                          */
;*    Last change :  Sun Dec 13 07:40:56 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The class slots structure                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    slots ...                                                        */
;*---------------------------------------------------------------------*/
(define-struct slot
   id               ;; the slot identifier
   name             ;; the slot name
   type             ;; the slot type
   stat-indexed?    ;; is the slot statically indexed (compile-time size) ?
   stat-bound       ;; the max bound of statically indexed slots
   dyna-indexed?    ;; is the slot dynamically indexed (run-time size) ?
   index?           ;; is the slot a index ?
   read-only?       ;; is the slot read-only
   default?         ;; does the slot has a default value ?
   default-value    ;; if it has, its default value
   assert           ;; an assertion regarding the slot
   virtual?         ;; is the slot virtual ?
   getter           ;; the virtual slot getter
   setter           ;; the virtual slot setter
   src)
