;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Object/access.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun  5 11:16:50 1996                          */
;*    Last change :  Fri Feb  5 10:01:52 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We make the class accessors                                      */
;*    -------------------------------------------------------------    */
;*    In this module we cannot use consume-module-clause! because      */
;*    the importation are already done.                                */
;*    -------------------------------------------------------------    */
;*    This constructors does not require any importation information   */
;*    since all accessors are always static.                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module object_access
   (include "Object/class.sch"
	    "Tools/trace.sch")
   (import  tools_error
	    tools_misc
	    type_type
	    type_env
	    type_tools
	    type_cache
	    ast_var
	    ast_ident
	    object_class
	    object_struct
	    object_slots
	    object_tools
	    module_module
	    module_impuse
	    engine_param)
   (export (make-coercion-clause c-id super)
	   (make-class-coercers class)
	   (make-class-pred! id::symbol class::class src-def import)
	   (import-class-pred! id::symbol class::class src-def ::symbol)
	   (make-class-slots-access! id type slots widening src-def import)
	   (import-class-slots-access! class-id type slots src-def ::symbol)
	   (import-class-makes! mk-id id type slots src-def ::symbol)
	   (make-class-allocate! id type holder src-def import)
	   (make-class-makes! widening mk-id id type slots src-def import)
	   (epairify def . srcs)
	   (make-class-make-formals slots)
	   (make-class-make-typed-formals slots)))
   
;*---------------------------------------------------------------------*/
;*    make-coercion-clause ...                                         */
;*    -------------------------------------------------------------    */
;*    This function has to take care that the super class may be       */
;*    incorrect (because this error is now detected very late in       */
;*    compilation). Thus on the iteration on super, we have to check   */
;*    that super is a class. If not, it is not a problem, we can       */
;*    simply stop the iteration. We can do this simple thing because   */
;*    eventually the super error will be detected and the compilation  */
;*    will be stopped.                                                 */
;*---------------------------------------------------------------------*/
(define (make-coercion-clause c-id super)
   (let* ((class->obj (class->obj-id c-id))
	  (obj->class (obj->class-id c-id))
	  (class-id?  (class?-id c-id)))
      (let loop ((super   super)
		 (coercer (list
			   `(coerce obj ,c-id (,class-id?) (,obj->class))
			   `(coerce ,c-id obj () (,class->obj)))))
	 (if (not (class? super))
	     `(type ,@coercer)
	     (let* ((super-id     (class-id super))
		    (class->super (class->super-id c-id super-id))
		    (super->class (super->class-id super-id c-id)))
		(loop (class-its-super super)
		      (cons
		       `(coerce ,super-id ,c-id	(,class-id?) (,super->class))
		       (cons
			`(coerce ,c-id ,super-id () (,class->super))
			coercer))))))))

;*---------------------------------------------------------------------*/
;*    make-class-coercers ...                                          */
;*    -------------------------------------------------------------    */
;*    We create all the coercers between type, obj and its super       */
;*    classes.                                                         */
;*    -------------------------------------------------------------    */
;*    This function has to take care that the super class may be       */
;*    incorrect (because this error is now detected very late in       */
;*    compilation). Thus on the iteration on super, we have to check   */
;*    that super is a class. If not, it is not a problem, we can       */
;*    simply stop the iteration. We can do this simple thing because   */
;*    eventually the super error will be detected and the compilation  */
;*    will be stopped.                                                 */
;*---------------------------------------------------------------------*/
(define (make-class-coercers class)
   (define (make-one-coercion from-id from-name to-id to-name)
      (let ((t->f (symbol-append to-id '-> from-id))
	    (f->t (symbol-append from-id '-> to-id)))
	 (produce-module-clause!
	  `(pragma (,t->f side-effect-free no-cfa-top)
		   (,f->t side-effect-free no-cfa-top)))
	 (list `(macro ,from-id ,t->f (,to-id)
		       ,(string-append "(" from-name ")"))
	       `(macro ,to-id ,f->t (,from-id)
		       ,(string-append "(" to-name ")")))))
   (let ((tid   (type-id   class))
	 (tname (type-name class)))
      (let loop ((super   (class-its-super class))
		 (coercer (make-one-coercion tid tname 'obj "obj_t")))
	 (if (not (class? super))
	     coercer
	     (let ((sid   (type-id super))
		   (sname (type-name super)))
		(loop (class-its-super super)
		      (append (make-one-coercion tid tname sid sname)
			      coercer)))))))

;*---------------------------------------------------------------------*/
;*    make-class-pred! ...                                             */
;*---------------------------------------------------------------------*/
(define (make-class-pred! id::symbol class::class src-def import)
   (let* ((id?     (symbol-append id '?))
	  (pred-id (symbol-append id '?::bool))
	  (holder  (class-holder class))
	  (super   (class-its-super class)))
      (if (not (class? super))
 	  ;; roots class tree must have ad-hoc predicate checker as
	  ;; the (@ object? __object) predicate.
	  '()
	  (let ((super-pred-id (symbol-append 'super- pred-id))
		(super-typed   (symbol-append 'super 4dots (type-id super))))
	     ;; the pragma declaration
	     (produce-module-clause!
	      `(,import (inline ,pred-id ::obj)))
	     (produce-module-clause!
	      `(pragma (,id? (predicate-of ,(class-id class)) no-cfa-top)))
	     ;; we produce the predicat definitions...
	     (list
	      (epairify `(define-inline (,pred-id obj)
			    (is-a? obj
				   (@ ,(global-id holder)
				      ,(global-module holder))))
			src-def))))))

;*---------------------------------------------------------------------*/
;*    import-class-pred! ...                                           */
;*---------------------------------------------------------------------*/
(define (import-class-pred! id::symbol class::class src-def module)
   (let* ((id?     (symbol-append id '?))
	  (pred-id (symbol-append id '?::bool))
	  (holder  (class-holder class))
	  (super   (class-its-super class)))
      (if (class? super)
	  (let ((super-pred-id (symbol-append 'super- pred-id))
		(super-typed   (symbol-append 'super 4dots (type-id super))))
	     ;; the pragma declaration
	     (import-parser module `(,pred-id ::obj))))))

;*---------------------------------------------------------------------*/
;*    make-class-makes! ...                                            */
;*---------------------------------------------------------------------*/
(define (make-class-makes! widening mk-id id type slots src-def import)
   [assert (widening) (memq widening '(widening make))]
   (let ((mk-heap-id  (symbol-append mk-id '- id))
	 (mk-stack-id (symbol-append mk-id '-stack- id)))
      (if (or (<fx *optim* 2) (not *optim-stack?*))
	  (list (make-class-make! widening malloc mk-heap-id
				  id type slots src-def
				  import))
	  (begin
	     (produce-module-clause!
	      `(pragma (,mk-heap-id (stack-alloc ,mk-stack-id))))
	     (list
	      (make-class-make! widening alloca mk-stack-id
				id type slots src-def
				import)
	      (make-class-make! widening malloc mk-heap-id
				id type slots src-def
				import))))))

;*---------------------------------------------------------------------*/
;*    make-class-make-formals ...                                      */
;*---------------------------------------------------------------------*/
(define (make-class-make-formals slots)
   (let loop ((slots   slots)
	      (formals '()))
      (cond
	 ((null? slots)
	  (reverse! formals))
	 ((slot-virtual? (car slots))
	  (loop (cdr slots) formals))
	 (else
	  (loop (cdr slots)
		(cons (slot-id (car slots))
		      formals))))))
	  
;*---------------------------------------------------------------------*/
;*    make-class-make-typed-formals ...                                */
;*---------------------------------------------------------------------*/
(define (make-class-make-typed-formals slots)
   (let loop ((slots   slots)
	      (formals '()))
      (cond
	 ((null? slots)
	  (reverse! formals))
	 ((slot-virtual? (car slots))
	  (loop (cdr slots) formals))
	 (else
	  (loop (cdr slots)
		(cons (symbol-append (slot-id (car slots))
				     4dots
				     (type-id (slot-type (car slots))))
		      formals))))))
	  
;*---------------------------------------------------------------------*/
;*    make-class-make! ...                                             */
;*---------------------------------------------------------------------*/
(define (make-class-make! widening alloc mk-id id type slots src-def import)
   (let* ((tid     (type-id type))
	  (holder  (class-holder type))
	  (constrs (find-class-constructors type))
	  (mk-tid  (symbol-append mk-id 4dots tid))
	  (f-ids   (make-class-make-formals slots))
	  (f-tids  (make-class-make-typed-formals slots))
	  (new     (gensym 'new))
	  (rid     (gensym 'i))
	  (rtid    (symbol-append rid '::long)))
      ;; the module clause of the maker
      (produce-module-clause!
       `(,import (,@(if (>=fx *optim* 2) '(inline) '()) ,mk-tid ,@f-tids)))
      ;; the definition of the maker
      (epairify `(,(if (>=fx *optim* 2) 'define-inline 'define)
		  (,mk-tid ,@f-tids)
		  (let ((,(symbol-append new 4dots tid) ,(alloc type 1)))
		     ,@(if (not (eq? widening 'widening))
			   `((object-class-num-set!
			      ,new
			      (class-num (@ ,(global-id holder)
					    ,(global-module holder))))
			     (object-widening-set! ,new #f))
			   '())
		     (let ,(map (lambda (ft f) `(,ft ,f)) f-tids f-ids)
			,@(make-class-slot-make! type new rid rtid slots f-ids)
			,@(if (and (pair? constrs)
				   (not (eq? widening 'widening)))
			      (map (lambda (constr)
				       `(,constr ,new))
				   constrs)
			      '())
			,new)))
		src-def)))

;*---------------------------------------------------------------------*/
;*    make-class-slot-make! ...                                        */
;*---------------------------------------------------------------------*/
(define (make-class-slot-make! type new rid rtid slots f-ids)
   (define (make-class-slot slot formal)
      (let ((loop (gensym 'loop)))
	 (cond
	    ((slot-dyna-indexed? slot)
	     ;; for an indexed field we have to make a
	     ;; malloc call and to fill all the field slots
	     `(begin
		 ,(make-pragma-indexed-init-set!
		   type
		   slot
		   new
		   (malloc (slot-type slot)
			   (symbol-append formal '-len)))
		 ;; this loop fills the field slots
		 (labels ((,loop (,rtid)
				 (if (=fx ,rid
					  ,(symbol-append formal '-len))
				     'done
				     (begin
					,(make-pragma-indexed-set!/widening
					  type
					  slot
					  new
					  formal
					  rid
					  #f)
					(,loop (+fx ,rid 1))))))
		    (,loop 0))))
	    ((slot-stat-indexed? slot)
	     ;; this loop fills the field slots
	     `(labels ((,loop (,rtid)
			      (if (=fx ,rid
				       (free-pragma::long
					,(slot-stat-bound slot)))
				  'done
				  (begin
				     ,(make-pragma-indexed-set!/widening
				       type
				       slot
				       new
				       formal
				       rid
				       #f)
				     (,loop (+fx ,rid 1))))))
		 (,loop 0)))
	    (else
	     (make-pragma-direct-set! type
				      slot
				      new
				      formal)))))
   (let loop ((slots slots)
	      (f-ids f-ids)
	      (res   '()))
      (cond
	 ((null? slots)
	  (reverse! res))
	 ((slot-virtual? (car slots))
	  (loop (cdr slots) f-ids res))
	 (else
	  (loop (cdr slots)
		(cdr f-ids)
		(cons (make-class-slot (car slots) (car f-ids)) res))))))

;*---------------------------------------------------------------------*/
;*    import-class-makes! ...                                          */
;*---------------------------------------------------------------------*/
(define (import-class-makes! mk-id id type slots src-def module)
   (let ((mk-heap-id  (symbol-append mk-id '- id))
	 (mk-stack-id (symbol-append mk-id '-stack- id)))
      (import-class-make! malloc mk-heap-id id type slots src-def module)))

;*---------------------------------------------------------------------*/
;*    import-class-make! ...                                           */
;*---------------------------------------------------------------------*/
(define (import-class-make! alloc mk-id id type slots src-def module)
   (let* ((tid     (type-id type))
	  (mk-tid  (symbol-append mk-id 4dots tid))
	  (f-tids  (make-class-make-typed-formals slots)))
      ;; the module clause of the maker
      (import-parser module `(,mk-tid ,@f-tids))))

;*---------------------------------------------------------------------*/
;*    make-class-allocate! ...                                         */
;*---------------------------------------------------------------------*/
(define (make-class-allocate! id type holder src-def import)
   (let* ((tid       (type-id type))
	  (alloc-id  (symbol-append 'allocate- id))
	  (alloc-tid (symbol-append alloc-id 4dots tid))
	  (new       (gensym 'new)))
      (produce-module-clause! `(,import (,alloc-tid)))
      (epairify `(define (,alloc-tid)
		    (let ((,(symbol-append new 4dots tid) ,(malloc type 1)))
		       (object-class-num-set! ,new
					      ((@ class-num __object)
					       (@ ,(global-id holder)
						  ,(global-module holder))))
		       (object-widening-set! ,new #f)
		       ,new))
		src-def)))

;*---------------------------------------------------------------------*/
;*    make-class-slots-access! ...                                     */
;*---------------------------------------------------------------------*/
(define (make-class-slots-access! class-id type slots widening src-def import)
   (let loop ((slots slots)
	      (res   '()))
      (if (null? slots)
	  (reverse! res)
	  (let ((slot (car slots)))
	     (if (slot-read-only? slot)
		 (loop (cdr slots)
		       (append (slot-ref class-id
					 type
					 slot
					 widening
					 src-def
					 import)
			       res))
		 (loop (cdr slots)
		       (append (slot-ref class-id
					 type
					 slot
					 widening
					 src-def
					 import)
			       (slot-set! class-id
					  type
					  slot
					  widening
					  src-def
					  import)
			       res)))))))

;*---------------------------------------------------------------------*/
;*    slot-ref ...                                                     */
;*---------------------------------------------------------------------*/
(define (slot-ref class-id type slot widening src-def import)
   (cond
      ((slot-dyna-indexed? slot)
       (slot-dyna-indexed-ref class-id type slot widening src-def import))
      ((slot-stat-indexed? slot)
       (slot-stat-indexed-ref class-id type slot widening src-def import))
      ((slot-virtual? slot)
       (slot-virtual-ref class-id type slot widening src-def import))
      (else
       (slot-direct-ref class-id type slot widening src-def import))))

;*---------------------------------------------------------------------*/
;*    slot-dyna-indexed-ref ...                                        */
;*---------------------------------------------------------------------*/
(define (slot-dyna-indexed-ref class-id type slot widening src-def import)
   (slot-indexed-ref class-id
		     type
		     slot
		     widening
		     `(,(symbol-append class-id '- (slot-id slot) '-len) obj)
		     src-def
		     import))

;*---------------------------------------------------------------------*/
;*    slot-stat-indexed-ref ...                                        */
;*---------------------------------------------------------------------*/
(define (slot-stat-indexed-ref class-id type slot widening src-def import)
   (slot-indexed-ref class-id
		     type
		     slot
		     widening
		     `(free-pragma::long ,(slot-stat-bound slot))
		     src-def import))

;*---------------------------------------------------------------------*/
;*    slot-indexed-ref ...                                             */
;*---------------------------------------------------------------------*/
(define (slot-indexed-ref class-id type slot widening max-bound src-def import)
   (define (indexed-ref-unsafe slot-ref-id slot-ref-tid)
      (epairify `(define-inline (,slot-ref-tid
				 ,(symbol-append 'obj 4dots (type-id type))
				 index::long)
		    ,(make-pragma-indexed-ref/widening type
						       slot
						       'obj
						       'index
						       widening))
		(if (slot? slot)
		    (slot-src slot)
		    slot)
		src-def))
   (define (indexed-ref-safe slot-ref-id slot-ref-tid)
      (epairify `(define (,slot-ref-tid
			  ,(symbol-append 'obj 4dots (type-id type))
			  index::long)
		    (if (>=fx index 0)
			(if (<fx index ,max-bound)
			    ,(make-pragma-indexed-ref/widening type
							       slot
							       'obj
							       'index
							       widening)
			    (error ',slot-ref-id "Index out of bound" index))
			(error ',slot-ref-id "Index out of bound" index)))
		(if (slot? slot)
		    (slot-src slot)
		    slot)
		src-def))
   (let* ((slot-ref-id  (symbol-append class-id '- (slot-id slot) '-ref))
	  (slot-ref-tid (symbol-append slot-ref-id
				       4dots
				       (type-id (slot-type slot))))
	  (tid          (symbol-append 4dots (type-id type)))
	  (holder       (class-holder type)))
      (cond
	 ((not *unsafe-range*)
	  (produce-module-clause! `(,import (,slot-ref-tid ,tid ::long)))
	  (produce-module-clause! `(pragma (,slot-ref-id side-effect-free
							 no-cfa-top)))
	  (list (indexed-ref-safe slot-ref-id slot-ref-tid)))
	 (else
	  (produce-module-clause! `(,import (inline ,slot-ref-tid ,tid ::long)))
	  (produce-module-clause! `(pragma (,slot-ref-id side-effect-free
							 no-cfa-top)))
	  (list (indexed-ref-unsafe slot-ref-id slot-ref-tid))))))

;*---------------------------------------------------------------------*/
;*    slot-virtual-ref ...                                             */
;*---------------------------------------------------------------------*/
(define (slot-virtual-ref class-id type slot widening src-def import)
   (let* ((slot-ref-id  (symbol-append class-id '- (slot-id slot)))
	  (slot-ref-tid (symbol-append slot-ref-id
				       4dots
				       (type-id (slot-type slot))))
	  (tid          (symbol-append 4dots (type-id type)))
	  (getter       (slot-getter slot))
	  (holder       (class-holder type))
	  (obj          (gensym 'obj)))
      (cond
	 ((<fx *optim* 2)
	  (produce-module-clause! `(,import (,slot-ref-tid ,tid)))
	  (produce-module-clause! `(pragma (,slot-ref-id side-effect-free
							 no-cfa-top)))
	  (list
	   (epairify `(define (,slot-ref-tid ,(symbol-append obj tid))
			 (,getter ,obj))
		     (if (slot? slot)
			 (slot-src slot)
			 slot)
		     src-def)))
	 (else
	  (produce-module-clause! `(,import (inline ,slot-ref-tid ,tid)))
	  (produce-module-clause! `(pragma (,slot-ref-id side-effect-free
							 no-cfa-top)))
	  (list
	   (epairify `(define-inline (,slot-ref-tid ,(symbol-append obj tid))
			 (,getter ,obj))
		     (if (slot? slot)
			 (slot-src slot)
			 slot)
		     src-def))))))

;*---------------------------------------------------------------------*/
;*    slot-direct-ref ...                                              */
;*---------------------------------------------------------------------*/
(define (slot-direct-ref class-id type slot widening src-def import)
   (let* ((slot-ref-id  (symbol-append class-id '- (slot-id slot)))
	  (slot-ref-tid (symbol-append slot-ref-id
				       4dots
				       (type-id (slot-type slot))))
	  (tid          (symbol-append 4dots (type-id type)))
	  (holder       (class-holder type)))
      (cond
	 ((<fx *optim* 2)
	  (produce-module-clause! `(,import (,slot-ref-tid ,tid)))
	  (produce-module-clause! `(pragma (,slot-ref-id side-effect-free
							 no-cfa-top)))
	  (list
	   (epairify `(define (,slot-ref-tid ,(symbol-append 'obj tid))
			 ,(make-pragma-direct-ref/widening type slot
							   'obj widening))
		     (if (slot? slot)
			 (slot-src slot)
			 slot)
		     src-def)))
	 (else
	  (produce-module-clause! `(,import (inline ,slot-ref-tid ,tid)))
	  (produce-module-clause! `(pragma (,slot-ref-id side-effect-free
							 no-cfa-top)))
	  (list
	   (epairify `(define-inline (,slot-ref-tid ,(symbol-append 'obj tid))
			 ,(make-pragma-direct-ref/widening type slot
							   'obj widening))
		     (if (slot? slot)
			 (slot-src slot)
			 slot)
		     src-def))))))

;*---------------------------------------------------------------------*/
;*    slot-set! ...                                                    */
;*---------------------------------------------------------------------*/
(define (slot-set! class-id type slot widening src-def import)
   (cond
      ((slot-dyna-indexed? slot)
       (slot-dyna-indexed-set! class-id type slot widening src-def import))
      ((slot-stat-indexed? slot)
       (slot-stat-indexed-set! class-id type slot widening src-def import))
      ((slot-virtual? slot)
       (slot-virtual-set! class-id type slot widening src-def import))
      (else
       (slot-direct-set! class-id type slot widening src-def import))))

;*---------------------------------------------------------------------*/
;*    slot-dyna-indexed-set! ...                                       */
;*---------------------------------------------------------------------*/
(define (slot-dyna-indexed-set! class-id type slot widening src-def import)
   (slot-indexed-set! class-id
		     type
		     slot
		     widening
		     `(,(symbol-append class-id '- (slot-id slot) '-len) obj)
		     src-def
		     import))

;*---------------------------------------------------------------------*/
;*    slot-stat-indexed-set! ...                                       */
;*---------------------------------------------------------------------*/
(define (slot-stat-indexed-set! class-id type slot widening src-def import)
   (slot-indexed-set! class-id
		     type
		     slot
		     widening
		     `(free-pragma::long ,(slot-stat-bound slot))
		     src-def
		     import))

;*---------------------------------------------------------------------*/
;*    slot-indexed-set! ...                                            */
;*---------------------------------------------------------------------*/
(define (slot-indexed-set! class-id type slot widening max-bound src-def import)
   (define (indexed-set!-unsafe slot-set!-id slot-set!-tid val-id val-tid)
      (epairify `(define-inline (,slot-set!-tid
				 ,(symbol-append 'obj 4dots (type-id type))
				 index::long
				 ,val-tid)
		    ,(make-pragma-indexed-set!/widening type
							slot
							'obj
							val-id
							'index
							widening))
		(if (slot? slot)
		    (slot-src slot)
		    slot)
		src-def))
   (define (indexed-set!-safe slot-set!-id slot-set!-tid val-id val-tid)
      (epairify `(define (,slot-set!-tid
			  ,(symbol-append 'obj 4dots (type-id type))
			  index::long
			  ,val-tid)
		    (if (>=fx index 0)
			(if (<fx index ,max-bound)
			    ,(make-pragma-indexed-set!/widening type
								slot
								'obj
								val-id
								'index
								widening)
			    (error ',slot-set!-id "Index out of bound" index))
			(error ',slot-set!-id "Index out of bound" index)))
		(if (slot? slot)
		    (slot-src slot)
		    slot)
		src-def))
   (let* ((slot-set!-id  (symbol-append class-id '- (slot-id slot) '-set!))
	  (slot-set!-tid (symbol-append slot-set!-id '::obj))
	  (tid           (symbol-append 4dots (type-id type)))
	  (holder        (class-holder type))
	  (v-id          (gensym 'val))
	  (v-tid         (symbol-append v-id
					4dots
					(type-id (slot-type slot)))))
      (cond
	 ((not *unsafe-range*)
	  (produce-module-clause! `(,import (,slot-set!-tid ,tid
							   ::long
							     ,v-tid)))
	  (list (indexed-set!-safe slot-set!-id slot-set!-tid v-id v-tid)))
	 (else
	  (produce-module-clause! `(,import (inline ,slot-set!-tid
						   ,tid
						   ::long
						     ,v-tid)))
	  (list
	   (indexed-set!-unsafe slot-set!-id slot-set!-tid v-id v-tid))))))

;*---------------------------------------------------------------------*/
;*    slot-virtual-set! ...                                             */
;*---------------------------------------------------------------------*/
(define (slot-virtual-set! class-id type slot widening src-def import)
   (let* ((slot-set!-id  (symbol-append class-id '- (slot-id slot) '-set!))
	  (slot-set!-tid (symbol-append slot-set!-id '::obj))
	  (tid           (symbol-append 4dots (type-id type)))
	  (holder        (class-holder type))
	  (setter        (slot-setter slot))
	  (v-id          (gensym 'val))
	  (obj           (gensym 'obj))
	  (v-tid         (symbol-append v-id
					4dots
					(type-id (slot-type slot)))))
      (cond
	 ((<fx *optim* 2)
	  (produce-module-clause! `(,import (,slot-set!-tid ,tid ,v-tid)))
	  (list
	   (epairify `(define (,slot-set!-tid ,(symbol-append obj tid)
					      ,v-tid)
			 (,setter ,obj ,v-id))
		     (if (slot? slot)
			 (slot-src slot)
			 slot)
		     src-def)))
	 (else
	  (produce-module-clause! `(,import (inline ,slot-set!-tid
						    ,tid
						    ,v-tid)))
	  (list
	   (epairify `(define-inline (,slot-set!-tid ,(symbol-append obj tid)
						     ,v-tid)
			 (,setter ,obj ,v-id))
		     (if (slot? slot)
			 (slot-src slot)
			 slot)
		     src-def))))))

;*---------------------------------------------------------------------*/
;*    slot-direct-set! ...                                             */
;*---------------------------------------------------------------------*/
(define (slot-direct-set! class-id type slot widening src-def import)
   (let* ((slot-set!-id  (symbol-append class-id '- (slot-id slot) '-set!))
	  (slot-set!-tid (symbol-append slot-set!-id '::obj))
	  (tid           (symbol-append 4dots (type-id type)))
	  (holder        (class-holder type))
	  (v-id          (gensym 'val))
	  (v-tid         (symbol-append v-id
					4dots
					(type-id (slot-type slot)))))
      (cond
	 ((<fx *optim* 2)
	  (produce-module-clause! `(,import (,slot-set!-tid ,tid ,v-tid)))
	  (list
	   (epairify `(define (,slot-set!-tid ,(symbol-append 'obj tid)
					      ,v-tid)
			 ,(make-pragma-direct-set!/widening type
							    slot
							    'obj
							    v-id
							    widening))
		     (if (slot? slot)
			 (slot-src slot)
			 slot)
		     src-def)))
	 (else
	  (produce-module-clause! `(,import (inline ,slot-set!-tid
						   ,tid
						   ,v-tid)))
	  (list
	   (epairify `(define-inline (,slot-set!-tid
				      ,(symbol-append 'obj tid) ,v-tid)
			 ,(make-pragma-direct-set!/widening type
							    slot
							    'obj
							    v-id
							    widening))
		     (if (slot? slot)
			 (slot-src slot)
			 slot)
		     src-def))))))

;*---------------------------------------------------------------------*/
;*    import-class-slots-access! ...                                   */
;*---------------------------------------------------------------------*/
(define (import-class-slots-access! class-id type slots src-def module)
   (for-each (lambda (slot)
		(import-slot-ref! class-id type slot src-def module)
		(if (not (slot-read-only? slot))
		    (import-slot-set! class-id type slot src-def module)))
	     slots))

;*---------------------------------------------------------------------*/
;*    import-slot-ref! ...                                             */
;*---------------------------------------------------------------------*/
(define (import-slot-ref! class-id type slot src-def module)
   (cond
      ((slot-dyna-indexed? slot)
       (import-slot-dyna-indexed-ref! class-id type slot src-def module))
      ((slot-stat-indexed? slot)
       (import-slot-stat-indexed-ref! class-id type slot src-def module))
      (else
       (import-slot-direct-ref! class-id type slot src-def module))))

;*---------------------------------------------------------------------*/
;*    import-slot-dyna-indexed-ref! ...                                */
;*---------------------------------------------------------------------*/
(define (import-slot-dyna-indexed-ref! class-id type slot src-def module)
   (import-slot-indexed-ref! class-id
			     type
			     slot
			     `(,(symbol-append class-id '-
					       (slot-id slot) '-len) obj)
			     src-def
			     module))

;*---------------------------------------------------------------------*/
;*    import-slot-stat-indexed-ref! ...                                */
;*---------------------------------------------------------------------*/
(define (import-slot-stat-indexed-ref! class-id type slot src-def module)
   (import-slot-indexed-ref! class-id
			     type
			     slot
			     `(free-pragma::long ,(slot-stat-bound slot))
			     src-def
			     module))

;*---------------------------------------------------------------------*/
;*    import-slot-indexed-ref! ...                                     */
;*---------------------------------------------------------------------*/
(define (import-slot-indexed-ref! class-id type slot max-bound src-def module)
   (let* ((slot-ref-id  (symbol-append class-id '- (slot-id slot) '-ref))
	  (slot-ref-tid (symbol-append slot-ref-id
				       4dots
				       (type-id (slot-type slot))))
	  (tid          (symbol-append 4dots (type-id type)))
	  (holder       (class-holder type)))
      (import-parser module `(,slot-ref-tid ,tid ::long))))

;*---------------------------------------------------------------------*/
;*    import-slot-direct-ref! ...                                      */
;*---------------------------------------------------------------------*/
(define (import-slot-direct-ref! class-id type slot src-def module)
   (let* ((slot-ref-id  (symbol-append class-id '- (slot-id slot)))
	  (slot-ref-tid (symbol-append slot-ref-id
				       4dots
				       (type-id (slot-type slot))))
	  (tid          (symbol-append 4dots (type-id type))))
      (import-parser module `(,slot-ref-tid ,tid))))

;*---------------------------------------------------------------------*/
;*    import-slot-set! ...                                             */
;*---------------------------------------------------------------------*/
(define (import-slot-set! class-id type slot src-def module)
   (cond
      ((slot-dyna-indexed? slot)
       (import-slot-dyna-indexed-set! class-id type slot src-def module))
      ((slot-stat-indexed? slot)
       (import-slot-stat-indexed-set! class-id type slot src-def module))
      (else
       (import-slot-direct-set! class-id type slot src-def module))))

;*---------------------------------------------------------------------*/
;*    import-slot-dyna-indexed-set! ...                                */
;*---------------------------------------------------------------------*/
(define (import-slot-dyna-indexed-set! class-id type slot src-def module)
   (import-slot-indexed-set! class-id
			     type
			     slot
			     `(,(symbol-append class-id '-
					       (slot-id slot) '-len) obj)
			     src-def
			     module))

;*---------------------------------------------------------------------*/
;*    import-slot-stat-indexed-set! ...                                */
;*---------------------------------------------------------------------*/
(define (import-slot-stat-indexed-set! class-id type slot src-def module)
   (import-slot-indexed-set! class-id
			     type
			     slot
			     `(free-pragma::long ,(slot-stat-bound slot))
			     src-def
			     module))

;*---------------------------------------------------------------------*/
;*    import-slot-indexed-set! ...                                     */
;*---------------------------------------------------------------------*/
(define (import-slot-indexed-set! class-id type slot max-bound src-def module)
   (let* ((slot-set!-id  (symbol-append class-id '- (slot-id slot) '-set!))
	  (slot-set!-tid (symbol-append slot-set!-id '::obj))
	  (tid           (symbol-append 4dots (type-id type)))
	  (v-id          (gensym 'val))
	  (v-tid         (symbol-append v-id
					4dots
					(type-id (slot-type slot)))))
      (import-parser module `(,slot-set!-tid ,tid ::long ,v-tid))))

;*---------------------------------------------------------------------*/
;*    import-slot-direct-set! ...                                      */
;*---------------------------------------------------------------------*/
(define (import-slot-direct-set! class-id type slot src-def module)
   (let* ((slot-set!-id  (symbol-append class-id '- (slot-id slot) '-set!))
	  (slot-set!-tid (symbol-append slot-set!-id '::obj))
	  (tid           (symbol-append 4dots (type-id type)))
	  (v-id          (gensym 'val))
	  (v-tid         (symbol-append v-id
					4dots
					(type-id (slot-type slot)))))
      (import-parser module `(,slot-set!-tid ,tid ,v-tid))))

;*---------------------------------------------------------------------*/
;*    epairify ...                                                     */
;*---------------------------------------------------------------------*/
(define (epairify def . srcs)
   (let loop ((srcs srcs))
      (cond
	 ((null? srcs)
	  def)
	 ((epair? (car srcs))
	  (econs (car def) (cdr def) (cer (car srcs))))
	 (else
	  (loop (cdr srcs))))))
	  
	  

