;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Module/with.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  4 16:28:03 1996                          */
;*    Last change :  Tue Jun 11 12:00:05 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The with clauses compilation.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_with
   (import module_module
	   engine_param
	   tools_error
	   module_impuse
	   read_access)
   (export (make-with-compiler)))

;*---------------------------------------------------------------------*/
;*    make-with-compiler ...                                           */
;*---------------------------------------------------------------------*/
(define (make-with-compiler)
   (instantiate::ccomp (id 'with) (producer with-producer)))

;*---------------------------------------------------------------------*/
;*    with-producer ...                                                */
;*---------------------------------------------------------------------*/
(define (with-producer clause)
   (match-case clause
      ((?- . ?protos)
       (for-each (lambda (proto) (with-parser proto clause)) protos))
      (else
       (user-error "Parse error"
		   (string-append "Illegal `with' clause")
		   clause
		   '()))))
   
;*---------------------------------------------------------------------*/
;*    with-parser ...                                                  */
;*---------------------------------------------------------------------*/
(define (with-parser proto clause)
   (match-case proto
      (((and ?name (? symbol?)) (and ?file (? string?)) . ?rest)
       (let loop ((rest   rest)
		  (fnames (list file)))
	  (cond
	     ((null? rest)
	      (add-access! name (reverse! fnames)))
	     ((string? (car rest))
	      (loop (cdr rest)
		    (cons (car rest) fnames)))
	     (else
	      (user-error "Parse error"
			  (string-append "Illegal `with' clause")
			  clause
			  '()))))
       (set! *with-files* (cons (o-name file) *with-files*))
       (import-with-module! name))
      (else
       (if (not (symbol? proto))
	   (user-error "Parse error"
		       (string-append "Illegal `with' clause")
		       clause
		       '())
	   (let ((b (assq proto *access-table*)))
	      (if (not b)
		  (user-error proto "can't access module" clause '())
		  (begin
		     (set! *with-files* (cons (o-name (cadr b)) *with-files*))
		     (import-with-module! proto))))))))

;*---------------------------------------------------------------------*/
;*    o-name ...                                                       */
;*---------------------------------------------------------------------*/
(define (o-name file)   
   (string-append (prefix file) ".o"))
	     
	
   
   
