;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Module/statexp.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  4 10:58:45 1996                          */
;*    Last change :  Thu Apr  9 08:06:30 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The static clauses compilation.                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_statexp
   (include "Ast/unit.sch")
   (import  module_module
	    module_prototype
	    module_class
	    module_checksum
	    tools_error
	    tools_args
	    type_type
	    ast_var
	    ast_ident
	    ast_find-gdefs
	    ast_glo-decl)
   (export  (make-static-compiler)
	    (make-export-compiler)))

;*---------------------------------------------------------------------*/
;*    make-static-compiler ...                                         */
;*---------------------------------------------------------------------*/
(define (make-static-compiler)
   (instantiate::ccomp (id 'static)
		       (producer statexp-producer)))

;*---------------------------------------------------------------------*/
;*    make-export-compiler ...                                         */
;*---------------------------------------------------------------------*/
(define (make-export-compiler)
   (instantiate::ccomp (id 'export)
		       (producer statexp-producer)
		       (consumer export-consumer)
		       (finalizer statexp-finalizer)
		       (checksummer export-checksummer)))

;*---------------------------------------------------------------------*/
;*    statexp-producer ...                                             */
;*---------------------------------------------------------------------*/
(define (statexp-producer clause)
   (let ((mode (car clause)))
      (match-case clause
	 ((?- . ?protos)
	  (for-each (lambda (proto) (statexp-parser proto mode)) protos)
	  '())
	 (else
	  (user-error "Parse error"
		      (string-append "Illegal `"
				     (string-downcase (symbol->string mode))
				     "' clause")
		      clause
		      '())))))

;*---------------------------------------------------------------------*/
;*    export-consumer ...                                              */
;*---------------------------------------------------------------------*/
(define (export-consumer module clause)
   (match-case clause
      ((?- . ?protos)
       protos)
      (else
       (user-error "Parse error" "Illegal `export' clause" clause '()))))
   
;*---------------------------------------------------------------------*/
;*    statexp-parser ...                                               */
;*---------------------------------------------------------------------*/
(define (statexp-parser prototype import)
   (let ((proto (parse-prototype prototype)))
      (if (not (pair? proto))
	  (user-error "Parse error" "Illegal prototype" prototype '())
	  (case (car proto)
	     ((sfun sifun sgfun)
	      (to-be-define! (declare-global-sfun! (cadr proto)
						   (caddr proto)
						   *module*
						   import
						   (car proto)
						   prototype)))
	     ((svar)
	      (to-be-define! (declare-global-svar! (cadr proto)
						   *module*
						   import
						   prototype)))
	     ((class)
	      (to-be-declare! (delay (declare-class! (cdr proto)
						     *module*
						     import
						     #f
						     prototype))))
	     ((final-class)
	      (to-be-declare! (delay (declare-class! (cdr proto)
						     *module*
						     import
						     #t
						     prototype))))
	     ((wide-class)
	      (to-be-declare! (delay (declare-wide-class! (cdr proto)
							  *module*
							  import
							  prototype))))
	     (else
	      (user-error "Parse error" "Illegal prototype" prototype '()))))))

;*---------------------------------------------------------------------*/
;*    *local-classes* ...                                              */
;*---------------------------------------------------------------------*/
(define *local-classes* '())

;*---------------------------------------------------------------------*/
;*    to-be-declare! ...                                               */
;*---------------------------------------------------------------------*/
(define (to-be-declare! exp)
   (set! *local-classes* (cons exp *local-classes*)))

;*---------------------------------------------------------------------*/
;*    statexp-finalizer ...                                            */
;*    -------------------------------------------------------------    */
;*    we declare local classes. They must be declared after imported   */
;*    classes (then after the finalization of imported modules)        */
;*    otherwise the class declaration process would fail when checking */
;*    the super class types (saying something like they are not        */
;*    classes). That why we have froozen their declaration until now.  */
;*---------------------------------------------------------------------*/
(define (statexp-finalizer)
   ;; we declare local classes
   (for-each force (reverse! *local-classes*))
   (set! *local-classes* '())
   ;; and we can finalize them
   (let ((classes (class-finalizer)))
      (if (pair? classes)
	  classes
	  'void)))

;*---------------------------------------------------------------------*/
;*    export-checksummer ...                                           */
;*    -------------------------------------------------------------    */
;*    The checksum associated to an export clause.                     */
;*---------------------------------------------------------------------*/
(define (export-checksummer eclause checksum)
   (define (proto-checksummer clause checksum)
      (let ((proto          (parse-prototype clause))
	    (symbol->number (lambda (s)
			       (string->0..2^x-1 (symbol->string s) 16))))
	 (if (not (pair? proto))
	     (user-error "Parse error" "Illegal prototype" eclause '())
	     (case (car proto)
		((sfun sifun sgfun)
		 (let loop ((checksum (bit-xor
				       (symbol->number (car proto))
				       (bit-xor (symbol->number (cadr proto))
						(bit-xor (arity (caddr proto))
							 checksum))))
			    (args     (caddr proto)))
		    (cond
		       ((null? args)
			checksum)
		       ((not (pair? args))
			(bit-xor (symbol->number 'obj) checksum))
		       ((cnst? (car args))
			(loop (bit-xor (cnst->integer (car args)) checksum)
			      (cdr args)))
		       (else
			(let* ((type (type-of-id (car args)))
			       (tid  (type-id type)))
			   (loop (bit-xor (symbol->number tid) checksum)
				 (cdr args)))))))
		((svar)
		 (bit-xor checksum (symbol->number (cadr proto))))
		((class)
		 (bit-xor checksum (get-class-hash (cadr proto) clause)))
		((final-class)
		 (bit-xor checksum
			  (bit-xor 12543
				   (get-class-hash (cadr proto) clause))))
		((wide-class)
		 (bit-xor checksum
			  (bit-xor 456747
				   (get-class-hash (cadr proto) clause))))
		(else
		 (user-error "Parse error" "Illegal prototype" clause '()))))))
   (let loop ((clauses  (cdr eclause))
	      (checksum checksum))
      (if (null? clauses)
	  checksum
	  (loop (cdr clauses)
		(proto-checksummer (car clauses) checksum)))))

  
   
