;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Module/prototype.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  4 14:27:58 1996                          */
;*    Last change :  Sun Dec 13 10:31:25 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The prototype management                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_prototype
   (import tools_error
	   tools_dsssl
	   type_type
	   ast_ident)
   (export (parse-prototype prototype)))

;*---------------------------------------------------------------------*/
;*    parse-prototype ...                                              */
;*---------------------------------------------------------------------*/
(define (parse-prototype prototype)
   (match-case prototype
      (((and ?class (or class final-class wide-class)) . ?-)
       (parse-class class (cdr prototype)))
      ((generic . ?-)
       (parse-function-prototype (cdr prototype) 'sgfun))
      ((inline . ?-)
       (parse-function-prototype (cdr prototype) 'sifun))
      ((?- . ?-)
       (parse-function-prototype prototype 'sfun))
      (else
       (parse-variable-prototype prototype))))

;*---------------------------------------------------------------------*/
;*    parse-function-prototype ...                                     */
;*---------------------------------------------------------------------*/
(define (parse-function-prototype proto class)
   (match-case proto
      (((and ?id (? symbol?)) . ?the-args)
       (let loop ((args the-args))
	  (cond
	     ((null? args)
	      (list class id (dsssl-formals-skeleton the-args)))
	     ((symbol? args)
	      (list class id the-args))
	     ((and (pair? args)
		   (or (symbol? (car args))
		       (dsssl-named-constant? (car args))))
	      (loop (cdr args)))
	     (else
	      #f))))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    parse-variable-prototype ...                                     */
;*---------------------------------------------------------------------*/
(define (parse-variable-prototype proto)
   (if (symbol? proto)
       (list 'svar proto) 
       #f))

;*---------------------------------------------------------------------*/
;*    parse-class ...                                                  */
;*---------------------------------------------------------------------*/
(define (parse-class class class-def)
   (define (parse-class-slots slots)
      (let loop ((slots slots)
		 (res   '()))
	 (cond
	    ((null? slots)
	     (reverse! res))
	    ((not (pair? slots))
	     #f)
	    (else
	     (let ((slot (parse-class-slot (car slots))))
		(if (not slot)
		    (user-error "Parse error"
				"Illegal class field definition"
				class-def)
		    (loop (cdr slots)
			  (cons slot res))))))))
   (match-case class-def
      (((and ?name (? symbol?)) (?constructor) . ?slots)
       (cons* class name constructor (parse-class-slots slots)))
      (((and ?name (? symbol?)) . ?slots)
       (cons* class name #f (parse-class-slots slots)))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    parse-class-slot ...                                             */
;*---------------------------------------------------------------------*/
(define (parse-class-slot slot)
   (define (epairify def src)
      (if (epair? src)
	  (econs (car def) (cdr def) (cer src))
	  def))
   (match-case slot
      ((? symbol?)
       (epairify `(id ,(parse-id slot)) slot))
      ((* (and ?id (? symbol?)) . ?att)
       (if (correct-attribut? att)
           (epairify `(* (id ,(parse-id id)) ,@att) slot)
           #f))
      ((+ (and ?integer ?len) (and ?id (? symbol?)) . ?att)
       (if (correct-attribut? att)
           (epairify `(+ ,(integer->string len) (id ,(parse-id id)) ,@att)
		     slot)
           #f))
      ((+ (and ?string ?len) (and ?id (? symbol?)) . ?att)
       (if (correct-attribut? att)
           (epairify `(+ ,len (id ,(parse-id id)) ,@att) slot)
           #f))
      (((and ?id (? symbol?)) . ?att)
       (if (correct-attribut? att)
           (epairify `((id ,(parse-id id)) ,@att) slot)
           #f))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    correct-attribut? ...                                            */
;*---------------------------------------------------------------------*/
(define (correct-attribut? attribut)
   (let loop ((attribut attribut))
      (cond
         ((null? attribut)
          #t)
         ((memq (car attribut) '(read-only))
          (loop (cdr attribut)))
         (else
          (match-case (car attribut)
	     ((get ?-)
	      (loop (cdr attribut)))
	     ((set ?-)
	      (loop (cdr attribut)))
             ((default ?-)
              (loop (cdr attribut)))
	     ((assert ?- . ?-)
	      (loop (cdr attribut)))
             (else
              #f))))))
