;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Module/pragma.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun  7 08:44:07 1996                          */
;*    Last change :  Thu Aug  8 16:49:11 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The pragma clause compilation                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_pragma
   (import module_module
	   tools_error
	   type_type
	   engine_param
	   ast_var
	   ast_env
	   ast_remove
	   type_env)
   (export (make-pragma-compiler)
	   (pragma-finalizer)))

;*---------------------------------------------------------------------*/
;*    make-pragma-compiler ...                                         */
;*---------------------------------------------------------------------*/
(define (make-pragma-compiler)
   (instantiate::ccomp (id 'pragma)
		       (producer  (pragma-producer *module*))
		       (consumer  (lambda (m c)
				     ((pragma-producer m) c)))
		       (finalizer pragma-finalizer)))

;*---------------------------------------------------------------------*/
;*    pragma-producer ...                                              */
;*---------------------------------------------------------------------*/
(define (pragma-producer module)
   (lambda (clause)
      (match-case clause
	 ((?- . ?protos)
	  (for-each (lambda (proto) (pragma-parser proto module clause))
		    protos)
	  '())
	 (else
	  (user-error "Parse error"
		      (string-append "Illegal `pragma' clause")
		      clause
		      '())))))
   
;*---------------------------------------------------------------------*/
;*    pragma-parser ...                                                */
;*---------------------------------------------------------------------*/
(define (pragma-parser proto module clause)
   (match-case proto
      (((and ?id (? symbol?)) . ?prop)
       (set! *pragma-list* (cons (list id module prop clause) *pragma-list*)))
      (else
       (user-error "Parse error" "Illegal `pragma' clause" clause '()))))

;*---------------------------------------------------------------------*/
;*    *pragma-list* ...                                                */
;*---------------------------------------------------------------------*/
(define *pragma-list* '())

;*---------------------------------------------------------------------*/
;*    pragma-finalizer ...                                             */
;*---------------------------------------------------------------------*/
(define (pragma-finalizer)
   (for-each (lambda (pragma)
		(match-case pragma
		   ((?id ?module ?prop* ?clause)
		    (let ((global (let ((global (find-global id module)))
				     (if (global? global)
					 global
					 (find-global id 'foreign)))))
		       (if (not (global? global))
			   (warning "pragma-finalizer"
				    "Can't find global variable -- "
				    `(@ ,id ,module))
			   (set-pragma-properties! global prop* clause))))
		   (else
		    (internal-error "pragma-finalizer"
				    "Illegal `pragma' finalizer form"
				    pragma))))
	     *pragma-list*)
   (set! *pragma-list* '())
   'void)

;*---------------------------------------------------------------------*/
;*    set-pragma-properties! ...                                       */
;*---------------------------------------------------------------------*/
(define (set-pragma-properties! global prop* clause)
   (for-each (lambda (prop) (set-pragma-property! global prop clause))
	     prop*))
 
;*---------------------------------------------------------------------*/
;*    set-pragma-property! ...                                         */
;*---------------------------------------------------------------------*/
(define (set-pragma-property! global prop clause)
   (match-case prop
      ((? symbol?)
       (case prop
	  ;; the side-effect-free pragma
	  ((side-effect-free)
	   (let ((value (global-value global)))
	      (if (not (fun? value))
		  (user-error "pragma"
			      "property is not concerning a function"
			      prop
			      '())
		  (fun-side-effect?-set! value #f))))
	  ;; the no-cfa-top pragma
	  ((no-cfa-top)
	   (let ((value (global-value global)))
	      (if (not (fun? value))
		  (user-error "pragma"
			      "property is not concerning a function"
			      prop
			      '())
		  (fun-top?-set! value #f))))
	  ((no-trace)
	   (let ((value (global-value global)))
	      (if (not (sfun? value))
		  (user-error "pragma"
			      "property is not concerning a sfunction"
			      prop
			      '())
		  (sfun-property-set! value (cons prop
						  (sfun-property value))))))
	  (else
	   (user-error "Parse error" "Illegal `pragma' form" clause '()))))
      (((and (? symbol?) ?key) (and (? symbol?) ?value))
       (case key
	  ;; the predicate-of pragma
	  ((predicate-of)
	   (let ((type  (use-type! value))
		 (value (global-value global)))
	      (if (not (fun? value))
		  (user-error "pragma"
			      "predicate is not associated to a function"
			      prop
			      '())
		  (begin
		     (fun-predicate-of-set! value type)
		     ;; predicate cannot be remove until
		     ;; coercers introduction pass
		     (remove-var-from! 'coerce global)
		     ;; furthermore a predicate is _always_
		     ;; free of side effects
		     (fun-side-effect?-set! value #f)))))
	  ;; the stack-alloc pragma
	  ((stack-alloc)
	   (let ((stack-alloc (find-global value (global-module global))))
	      (cond
		 ((not (global? stack-alloc))
		  (user-error "pragma"
			      "Can't find stack allocator"
			      prop
			      '()))
		 ((not (fun? (global-value global)))
		  (user-error "pragma"
			      "alloctor is not a function"
			      prop
			      '()))
		 (else
		  ;; stack allocators cannot be remove before
		  ;; the stack alloction pass.
		  (if *optim-stack?* (remove-var-from! 'cfa stack-alloc))
		  ;; we set the pragma property
		  (fun-stack-allocator-set! (global-value global)
					    stack-alloc)))))
	  (else
	   (user-error "Parse error" "Illegal `pragma' form" prop '()))))
      (else
       (user-error "Parse error"
		   "Illegal `pragma' form"
		   (if (pair? prop) prop clause)
		   '()))))
	 
