;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Module/main.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  4 11:51:01 1996                          */
;*    Last change :  Fri Apr 10 18:25:07 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The main clause compilation.                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_main
   (import module_module
	   tools_error
	   type_type
	   type_cache
	   ast_var
	   ast_env
	   engine_param)
   (export (make-main-compiler)))

;*---------------------------------------------------------------------*/
;*    make-main-compiler ...                                           */
;*    -------------------------------------------------------------    */
;*    We don't need a checksum for main clauses because, for each      */
;*    main clause, an export clause has been generated. This export    */
;*    clause will be naturally checksummed.                            */
;*---------------------------------------------------------------------*/
(define (make-main-compiler)
   (instantiate::ccomp (id 'main)
		       (producer main-producer)
		       (consumer main-consumer)))

;*---------------------------------------------------------------------*/
;*    correct-main? ...                                                */
;*    -------------------------------------------------------------    */
;*    A main is a function, which has exactly one argument of          */
;*    type `obj' or `pair'.                                            */
;*---------------------------------------------------------------------*/
(define (correct-main?::bool global::global)
   (let ((sfun (global-value global)))
      (and (sfun? sfun)
	   (=fx (sfun-arity sfun) 1)
	   (let* ((args (car (sfun-args sfun)))
		  (type (local-type args)))
	      (or (eq? type *obj*) (eq? type *pair*))))))

;*---------------------------------------------------------------------*/
;*    main-producer ...                                                */
;*---------------------------------------------------------------------*/
(define (main-producer clause)
   (if (or (eq? *main* 'imported) (global? *main*))
       (duplicate-main-error clause)
       (match-case clause
	  ((?- (and (? symbol?) ?main))
	   (let ((global (find-global main *module*)))
	      (if (global? global)
		  (if (not (correct-main? global))
		      (user-error *module*
				  "Illegal declaration of main function"
				  main
				  '()))
		  (begin
		     (if (>fx *bdb-debug* 0)
			 (produce-module-clause! `(export (,main argv::obj)))
			 (produce-module-clause! `(export (,main argv::pair))))
		     (set! *main* (find-global main *module*))))))
	  (else
	   (user-error "Parse error" "Illegal main clause" clause '())))))

;*---------------------------------------------------------------------*/
;*    main-consumer ...                                                */
;*---------------------------------------------------------------------*/
(define (main-consumer module clause)
   (if (global? *main*)
       (duplicate-main-error clause)
       (set! *main* 'imported))
   '())

;*---------------------------------------------------------------------*/
;*    duplicate-main-error ...                                         */
;*---------------------------------------------------------------------*/
(define (duplicate-main-error clause)
   (user-error "Parse error" "Duplicated main clause" clause '()))

