;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Module/load.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun  7 08:44:07 1996                          */
;*    Last change :  Tue Jun 11 11:59:17 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The load clause compilation                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_load
   (import module_module
	   engine_param
	   tools_error
	   type_type
	   ast_var
	   ast_env
	   type_env
	   tools_speek
	   read_load)
   (export (make-load-compiler)))

;*---------------------------------------------------------------------*/
;*    make-load-compiler ...                                           */
;*---------------------------------------------------------------------*/
(define (make-load-compiler)
   (instantiate::ccomp (id 'load)
		       (producer load-producer)))

;*---------------------------------------------------------------------*/
;*    load-producer ...                                                */
;*---------------------------------------------------------------------*/
(define (load-producer clause)
   (match-case clause
      ((?- . ?protos)
       (for-each (lambda (proto) (load-parser proto clause)) protos))
      (else
       (user-error "Parse error"
		   (string-append "Illegal `load' clause")
		   clause
		   '()))))
   
;*---------------------------------------------------------------------*/
;*    load-parser ...                                                  */
;*---------------------------------------------------------------------*/
(define (load-parser proto clause)
   (match-case proto
      (((and ?module (? symbol?)) (and ?file (? string?)) . ?files)
       (let loop ((f files))
	  (cond
	     ((null? f)
	      (load-module module (cons file files)))
	     ((not (string? (car f)))
	      (user-error "Parse error" "Illegal load clause" clause '()))
	     (else
	      (loop (cdr f))))))
      ((? symbol?)
       (let ((b (assq proto *access-table*)))
	  (if (not b)
	      (user-error "load" "Can't load module" proto)
	      (load-module proto (cdr b)))))
      (else
       (user-error "Parse error" "Illegal load clause" clause '()))))

