;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Module/library.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul  9 16:05:09 1996                          */
;*    Last change :  Fri Apr 10 17:29:41 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Library finalizer                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_library
   (include "Ast/unit.sch")
   (import  type_type
	    ast_var
	    ast_env
	    module_module
	    module_impuse
	    engine_param
	    bdb_setting)
   (export  (library-finalizer)))

;*---------------------------------------------------------------------*/
;*    library-finalizer ...                                            */
;*---------------------------------------------------------------------*/
(define (library-finalizer)
   ;; we set the key
   (set! *key* (gensym))
   ;; we mark the already imported modules
   (for-each (lambda (module) (putprop! module *key* #t))
	     (get-imported-modules))
   ;; we also mark the dummy `foreign' module
   (putprop! 'foreign *key* #t)
   ;; and, of course, the current module
   (putprop! *module* *key* #t)
   ;; first, we collect all the needed library modules
   (for-each-global! (lambda (global)
			(if (and (>fx (global-occurrence global) 0)
				 (global-library? global))
			    (need-library-module! (global-module global)))))
   ;; when compiling for bdb we must initialize the bdb module
   (if (>fx *bdb-debug* 0)
       (need-library-module! *bdb-module*))
   ;; then we declare a special unit
   (let ((modules *needed-modules*))
      (if (null? modules)
	  '()
	  (let loop ((modules      modules)
		     (init-call* '(#unspecified)))
	     (if (null? modules)
		 (unit 'library-modules 2 init-call* #t)
		 (let* ((id          (car modules))
			(init-fun-id (module-initialization-id id)))
		    (loop (cdr modules)
			  (cons `((@ ,init-fun-id ,id) 0
						       ;; 0 means here not to
						       ;; perform version
						       ;; checking about
						       ;; library
						       ,(symbol->string
							 *module*))
				init-call*))))))))

;*---------------------------------------------------------------------*/
;*    *needed-modules* ...                                             */
;*---------------------------------------------------------------------*/
(define *needed-modules* '())

;*---------------------------------------------------------------------*/
;*    *key* ...                                                        */
;*---------------------------------------------------------------------*/
(define *key* #unspecified)

;*---------------------------------------------------------------------*/
;*    need-library-module! ...                                         */
;*---------------------------------------------------------------------*/
(define (need-library-module! module::symbol)
   (if (not (getprop module *key*))
       (begin
	  (putprop! module *key* #t)
	  (set! *needed-modules* (cons module *needed-modules*)))))

