;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Module/include.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 31 11:54:16 1996                          */
;*    Last change :  Wed Dec 17 17:35:56 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `include' clauses compilation                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_include
   (include "Ast/unit.sch")
   (import  module_module
	    tools_error
	    read_include)
   (export  (make-include-compiler)
	    (get-include-consumed-directive)
	    (reset-include-consumed-directive!)
	    (get-include-consumed-code)
	    (reset-include-consumed-code!)
	    (get-toplevel-unit)
	    (get-toplevel-unit-weight)))

;*---------------------------------------------------------------------*/
;*    make-include-compiler ...                                        */
;*---------------------------------------------------------------------*/
(define (make-include-compiler)
   (instantiate::ccomp (id 'include)
		       (producer include-producer)
		       (consumer include-consumer)
		       (finalizer include-finalizer)))
 
;*---------------------------------------------------------------------*/
;*    *produced-code* ...                                              */
;*---------------------------------------------------------------------*/
(define *produced-code* '())

;*---------------------------------------------------------------------*/
;*    include-producer ...                                             */
;*---------------------------------------------------------------------*/
(define (include-producer clause)
   (define (include-error)
      (user-error "Parse error" "Illegal `include' clause" clause '()))
   (let loop ((files (cdr clause)))
      (cond
	 ((null? files)
	  '())
	 ((not (pair? files))
	  (include-error))
	 (else
	  (let ((file (car files)))
	     (if (not (string? file))
		 (include-error)
		 (let* ((src       (read-include file))
			(directive (car src))
			(src-code  (reverse! (cdr src))))
		    ;; we parse the directive clause
		    (if (pair? directive)
			(for-each produce-module-clause! (cdr directive)))
		    (set! *produced-code* (append src-code *produced-code*))
		    (loop (cdr files)))))))))

;*---------------------------------------------------------------------*/
;*    *consumed-directive* ...                                         */
;*---------------------------------------------------------------------*/
(define *consumed-directive* '())

;*---------------------------------------------------------------------*/
;*    get-include-consumed-directive ...                               */
;*---------------------------------------------------------------------*/
(define (get-include-consumed-directive)
   *consumed-directive*)

;*---------------------------------------------------------------------*/
;*    reset-include-consumed-directive! ...                            */
;*---------------------------------------------------------------------*/
(define (reset-include-consumed-directive!)
   (set! *consumed-directive* '()))

;*---------------------------------------------------------------------*/
;*    *consumed-code* ...                                              */
;*---------------------------------------------------------------------*/
(define *consumed-code* '())

;*---------------------------------------------------------------------*/
;*    get-include-consumed-code ...                                    */
;*---------------------------------------------------------------------*/
(define (get-include-consumed-code)
   *consumed-code*)

;*---------------------------------------------------------------------*/
;*    reset-include-consumed-code! ...                                 */
;*---------------------------------------------------------------------*/
(define (reset-include-consumed-code!)
   (set! *consumed-code* '()))

;*---------------------------------------------------------------------*/
;*    include-consumer ...                                             */
;*---------------------------------------------------------------------*/
(define (include-consumer module::symbol clause)
   (define (include-error)
      (user-error "Parse error" "Illegal `include' clause" clause '()))
   (let loop ((files (cdr clause)))
      (cond
	 ((null? files)
	  '())
	 ((not (pair? files))
	  (include-error))
	 (else
	  (let ((file (car files)))
	     (if (not (string? file))
		 (include-error)
		 (let* ((src       (read-include file))
			(directive (car src))
			(src-code  (cdr src)))
		    (begin
		       ;; we parse the directive clause
		       (if (pair? directive)
			   (for-each
			    (lambda (d)
			       (set! *consumed-directive*
				     (append (consume-module-clause! module d)
					     *consumed-directive*)))
			    (cdr directive)))
		       (set! *consumed-code* (append src-code *consumed-code*))
		       '()))))))))

;*---------------------------------------------------------------------*/
;*    *toplevel-unit* ...                                              */
;*---------------------------------------------------------------------*/
(define *toplevel-unit* #f)

;*---------------------------------------------------------------------*/
;*    get-toplevel-unit ...                                            */
;*---------------------------------------------------------------------*/
(define (get-toplevel-unit)
   [assert (*toplevel-unit*) (unit? *toplevel-unit*)]
   *toplevel-unit*)

;*---------------------------------------------------------------------*/
;*    get-toplevel-unit-weight ...                                     */
;*---------------------------------------------------------------------*/
(define (get-toplevel-unit-weight)
   100)

;*---------------------------------------------------------------------*/
;*    include-finalizer ...                                            */
;*---------------------------------------------------------------------*/
(define (include-finalizer)
   (set! *toplevel-unit* (unit 'toplevel
			       (get-toplevel-unit-weight)
			       (reverse! *produced-code*)
			       #t))
   (list *toplevel-unit*))

