;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Module/class.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun  5 10:52:20 1996                          */
;*    Last change :  Fri Feb  5 10:01:08 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The class clause handling                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_class
   (include "Ast/unit.sch"
	    "Object/class.sch"
	    "Tools/trace.sch")
   (import  module_module
	    module_impuse
	    module_include
	    engine_param
	    tools_shape
	    tools_error
	    type_type
	    type_env
	    ast_ident
	    ast_var
	    ast_env
	    object_class
	    object_plain-access
	    object_wide-access)
   (export  (declare-class!      cdef mod::symbol imp::symbol fin::bool ::obj)
	    (declare-wide-class! cdef mod::symbol imp::symbol ::obj)
	    (get-class-hash      class-id::symbol fields)
	    (get-object-unit)
	    (get-method-unit)
	    (class-finalizer)))

;*---------------------------------------------------------------------*/
;*    Object units ...                                                 */
;*---------------------------------------------------------------------*/
(define *object-unit* #unspecified)
(define *method-unit* #unspecified)

;*---------------------------------------------------------------------*/
;*    get-object-unit ...                                              */
;*---------------------------------------------------------------------*/
(define (get-object-unit)
   *object-unit*)

;*---------------------------------------------------------------------*/
;*    get-method-unit ...                                              */
;*---------------------------------------------------------------------*/
(define (get-method-unit)
   *method-unit*)
 
;*---------------------------------------------------------------------*/
;*    declare-class! ...                                               */
;*---------------------------------------------------------------------*/
(define (declare-class! class-def module import final? src-def)
   (trace (ast 2) "declare-class!: " src-def #\Newline)
   ;; We create the class holder
   ;; and we create a type for this class
   (let* ((class-var (car class-def))
	  (class-id  (id-of-id class-var))
	  (holder    (if (or (eq? import 'import) (eq? import 'use))
			 (import-parser module class-id)
			 (begin
			    (produce-module-clause! `(,import ,class-id))
			    (find-global class-id module))))
	  (type      (declare-class-type! class-def holder #f final? src-def)))
      ;; type can be something else than a class if an error has been found
      (if (class? type)
	  (begin
	     (cond
		((memq import '(export static))
		 ;; this is a domestic class, we have to declare the
		 ;; global variable that holds the class object
		 (make-add-class! holder type src-def)
		 ;; we also have to declare the accessors.
		 (add-declaration!
		  type
		  (delay
		     (make-plain-class-accessors! class-def
						  type
						  src-def
						  import))))
		((and (>=fx *optim* 2) (<=fx *bdb-debug* 0))
		 ;; when compiling for optimization (and not debugging)
		 ;; we inline the class accessors, that it, we make as if
		 ;; class accessors where locals.
		 (add-declaration!
		  type
		  (delay
		     (make-plain-class-accessors! class-def
						  type
						  src-def
						  import))))
		(else
		 ;; when importing a class, we import the accessors...
		 (add-declaration!
		  type
		  (delay
		     (import-plain-class-accessors! class-def
						    type
						    src-def
						    module)))))
	     type)
	  #unspecified)))

;*---------------------------------------------------------------------*/
;*    declare-wide-class! ...                                          */
;*---------------------------------------------------------------------*/
(define (declare-wide-class! class-def module import src-def)
   ;; We create the class holder
   ;; and we create a type for this class
   (let* ((class-var (car class-def))
	  (class-id  (id-of-id class-var))
	  (holder    (if (or (eq? import 'import) (eq? import 'use))
			 (import-parser module class-id)
			 (begin
			    (produce-module-clause! `(,import ,class-id))
			    (find-global class-id module))))
	  (type      (declare-class-type! class-def
					  holder
					  (gensym 'widening)
					  #f
					  src-def)))
      ;; type can be something else than a class is an error has been found
      (if (class? type)
	  ;; then, we declare the class when it is a class definition
	  (cond
	     ((memq import '(export static))
	      ;; this is a domestic class, we have to declare the
	      ;; global variable that holds the class object
	      (make-add-class! holder type src-def)
	      ;; we also have to declare the accessors.
	      (add-declaration!
	       type
	       (delay
		  (make-wide-class-accessors! class-def
					      type
					      src-def
					      import))))
	     ((and (>=fx *optim* 2) (<=fx *bdb-debug* 0))
	      ;; when compiling for optimization (and not debugging)
	      ;; we inline the class accessors, that it, we make as if
	      ;; class accessors where locals.
	      (add-declaration!
	       type
	       (delay
		  (make-wide-class-accessors! class-def
					      type
					      src-def
					      import))))
	     (else
	      ;; when importing a class, we import the accessors...
	      (add-declaration!
	       type
	       (delay
		  (import-wide-class-accessors! class-def
						type
						src-def
						module))))))))

;*---------------------------------------------------------------------*/
;*    add-declaration! ...                                             */
;*---------------------------------------------------------------------*/
(define (add-declaration! type delayed)
   (set! *class-accesses* (cons (cons type delayed) *class-accesses*)))

;*---------------------------------------------------------------------*/
;*    *class-accesses* ...                                             */
;*---------------------------------------------------------------------*/
(define *class-accesses* '())

;*---------------------------------------------------------------------*/
;*    *declared-classes* ...                                           */
;*---------------------------------------------------------------------*/
(define *declared-classes* '())

;*---------------------------------------------------------------------*/
;*    make-add-class! ...                                              */
;*---------------------------------------------------------------------*/
(define (make-add-class! holder class src-def)
   (let* ((super          (class-its-super class))
	  (holder-id      (global-id holder))
	  (class-id       (type-id class))
	  (class-module   (global-module holder))
	  (class-alloc-id (symbol-append 'allocate- class-id))
	  (class-alloc    `(@ ,class-alloc-id ,class-module))
	  (hash           (get-class-hash class-id (cddr src-def)))
	  (constr         (class-constructor class)))
      (let ((decl (if (not (class? super))
		      `(define ,holder-id
			  ((@ add-class! __object) ',class-id
						   #f
						   ,class-alloc
						   ,hash
						   ,(make-class-fields
						     class-id
						     (cddr src-def))
						   ,constr))
		      (let* ((sholder        (class-holder super))
			     (sholder-id     (global-id sholder))
			     (sholder-module (global-module sholder)))
			 `(define ,holder-id
			     ((@ add-class! __object) ',class-id
						      (@ ,sholder-id
							 ,sholder-module)
						      ,class-alloc
						      ,hash
						      ,(make-class-fields
							class-id
							(cddr src-def))
						      ,constr))))))
	 (set! *declared-classes* (cons decl *declared-classes*)))))

;*---------------------------------------------------------------------*/
;*    get-hash-class ...                                               */
;*---------------------------------------------------------------------*/
(define (get-class-hash class-id fields)
   (let loop ((fields fields)
	      (hash (string->0..2^x-1 (symbol->string class-id) 16)))
      (if (null? fields)
	  hash
	  (let ((field (car fields)))
	     (match-case field
		((?-)
		 (loop (cdr fields)
		       (bit-xor hash 2344)))
		((? symbol?)
		 (loop (cdr fields)
		       (bit-xor hash
				(string->0..2^x-1
				 (symbol->string field)
				 16))))
		((* (and ?id (? symbol?)) . ?att)
		 (loop (cdr fields)
		       (bit-xor hash
				(string->0..2^x-1
				 (string-append
				  "* "
				  (symbol->string id))
				 16))))
		((+ (and ?integer ?len) (and ?id (? symbol?)) . ?att)
		 (loop (cdr fields)
		       (bit-xor hash
				(string->0..2^x-1
				 (string-append
				  "+ "
				  (integer->string len)
				  (symbol->string id))
				 16))))
		((+ (and ?string ?len) (and ?id (? symbol?)) . ?att)
		 (loop (cdr fields)
		       (bit-xor hash
				(string->0..2^x-1
				 (string-append
				  "+ "
				  len
				  (symbol->string id))
				 16))))
		(((and ?id (? symbol?)) . ?att)
		 (loop (cdr fields)
		       (bit-xor hash
				(string->0..2^x-1
				 (symbol->string id)
				 16)))))))))

;*---------------------------------------------------------------------*/
;*    make-class-fields ...                                            */
;*    -------------------------------------------------------------    */
;*    We have not found a better way to do it. We re-parse the class   */
;*    definition (according to module_prototype and object_slots)      */
;*    to produce the correct proper list for the class declaration.    */
;*---------------------------------------------------------------------*/
(define (make-class-fields class-id slot-defs)
   (define (read-only? attr)
      (let loop ((attr attr))
	 (cond
	    ((null? attr)
	     #f)
	    ((memq (car attr) '(read-only))
	     #t)
	    (else
	     (loop (cdr attr))))))
   (define (make-slot-field slot)
      (match-case slot
	 ((? symbol?)
	  (let ((id (fast-id-of-id slot)))
	     `(vector ',slot
		      ,(symbol-append class-id '- id)
		      ,(symbol-append class-id '- id '-set!)
		      #unspecified)))
	 ((* (and ?id (? symbol?)) . ?att)
	  (let ((id (fast-id-of-id id)))
	     `(vector ',id
		      ,(symbol-append class-id '- id '-ref)
		      ,(if (not (read-only? att))
			   (symbol-append class-id '- id '-set!)
			   '#unspecified)
		      ,(symbol-append class-id '- id '-len))))
	 ((+ (and ?integer ?len) (and ?id (? symbol?)) . ?att)
	  (let ((id (fast-id-of-id id)))
	     `(vector ',id
		      ,(symbol-append class-id '- id '-ref)
		      ,(if (not (read-only? att))
			   (symbol-append class-id '- id '-set!)
			   '#unspecified)
		      (lambda (object) ,len))))
	 ((+ (and ?string ?len) (and ?id (? symbol?)) . ?att)
	  (let ((id (fast-id-of-id id)))
	     `(vector ',id
		      ,(symbol-append class-id '- id '-ref)
		      ,(if (not (read-only? att))
			   (symbol-append class-id '- id '-set!)
			   '#unspecified)
		      (lambda (object) (pragma::long ,len)))))
	 (((and ?id (? symbol?)) . ?att)
	  (let ((id (fast-id-of-id id)))
	     `(vector ',id
		      ,(symbol-append class-id '- id)
		      ,(if (not (read-only? att))
			   (symbol-append class-id '- id '-set!)
			   '#unspecified)
		      #unspecified)))
	 (else
	  (internal-error "make-class-fields"
			  "Illegal slot definition"
			  slot))))
   (let ((slot-defs (match-case slot-defs
		       (((?-) . ?rest)
			rest)
		       (else
			slot-defs))))
      (if *reflection?*
	  `(list ,@(map make-slot-field slot-defs))
	  #unspecified)))
   
;*---------------------------------------------------------------------*/
;*    class-finalizer ...                                              */
;*    -------------------------------------------------------------    */
;*    @label class unit@                                               */
;*---------------------------------------------------------------------*/
(define (class-finalizer)
   (cond
      ((and (null? *declared-classes*) (null? *class-accesses*))
       'void)
      (else
       ;; class definitions and method definitions are splitted because
       ;; method can't be added before imported modules are initialized and
       ;; modules cannot be initialized before classes are defined. The
       ;; initialization order is a difficult problem. The unit number
       ;; for object _must_ be greater than the unit number for importations.
       ;; See the module_impuse module (@ref impuse.scm:importation unit@)
       ;; to the unit number for importations. The consequence of that
       ;; initialization order is that it is not possible inside a module M1
       ;; that defines a class C to import a module M2 that uses C.
       (let ((body (append (reverse! *declared-classes*)
			   (force-class-accesses))))
	  (set! *object-unit* (unit 'object
				    19
				    (if (pair? body) body '(#unspecified))
				    #t))
	  ;; the method unit weight (20 here) is constraint as follow:
	  ;;    object-weight < import-weight < method-weight < toplevel-weight
	  ;;    any change must be reported in modules:
	  ;;    module_impuse (function import-finalizer)
	  ;;    module_include (function include-finalizer)
	  [assert () (<fx 20 (get-toplevel-unit-weight))]
	  (set! *method-unit* (unit 'method
				    20
				    ;; this unit may be empty so we initialize
				    ;; it with a dummy expression.
				    '(#unspecified)
				    #t))
	  (list *object-unit* *method-unit*)))))
	     
;*---------------------------------------------------------------------*/
;*    force-class-accesses ...                                         */
;*    -------------------------------------------------------------    */
;*    Class accessors computation is tricky. We have to sord the class */
;*    before creating the accessors. That is, the classes have to be   */
;*    defined from the root of the tree to the node.                   */
;*---------------------------------------------------------------------*/
(define (force-class-accesses)
   ;; first we process the non wide classes
   (let loop ((cur    (reverse! *class-accesses*))
	      (next   '())
	      (access '()))
      (if (null? cur)
	  (if (null? next)
	      access
	      (loop next '() access))
	  (let* ((class (car (car cur)))
		 (super (class-its-super class)))
	     (cond
		((eq? super class)
		 ;; this is the root we proceed now
		 (loop (cdr cur)
		       next
		       (append (force (cdr (car cur)))
			       access)))
		((not (class? super))
		 (if (type? super)
		     ;; this is and error that will be pointed out later. for
		     ;; the moment we simply ignore it.
		     (begin
			(class-slots-set! class '())
			(loop (cdr cur)
			      next
			      access))
		     (loop (cdr cur)
			   next
			   (append (force (cdr (car cur)))
				   access))))
		((eq? (class-slots super) #unspecified)
		 ;; we have not yet seen the super, we delay again
		 (loop (cdr cur)
		       (cons (car cur) next)
		       access))
		(else
		 ;; ok, the super has been proceed, we go for this class
		 (loop (cdr cur)
		       next
		       (append (force (cdr (car cur)))
			       access))))))))

