;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Module/checksum.scm     */
;*    -------------------------------------------------------------    */
;*    Author      :  SERRANO Manuel                                    */
;*    Creation    :  Thu Aug 21 08:38:45 1997                          */
;*    Last change :  Thu Aug 21 10:49:08 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We compute checksum for modules in order to be able to check,    */
;*    at module initialization time, that modules are coherent. Only   */
;*    exported and extern values (bindings and classes) are considered */
;*    for checksumming.                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_checksum
   
   (include "Ast/unit.sch"
	    "Engine/pass.sch")
   
   (import  engine_param
	    engine_pass
	    tools_error)
   
   (export (clause-checksummer::long clause ::long)
	   (initial-checksum::long   name::symbol)))

;*---------------------------------------------------------------------*/
;*    initial-checksum ...                                             */
;*---------------------------------------------------------------------*/
(define (initial-checksum mname)
   (let ((checksum (bit-xor (string->0..2^x-1 *bigloo-name* 16)
			    (string->0..2^x-1 (symbol->string mname) 16))))
      (if (char? *bigloo-level*)
	  (bit-xor checksum (char->integer *bigloo-level*))
	  checksum)))
   
;*---------------------------------------------------------------------*/
;*    clause-checksummer ...                                           */
;*---------------------------------------------------------------------*/
(define (clause-checksummer clause checksum)
   (define (symbol->number s)
      (string->0..2^x-1 (symbol->string s) 16))
   (define (atom->number checksum clause)
      (cond
	 ((number? clause)
	  (bit-xor checksum clause))
	 ((char? clause)
	  (bit-xor checksum (char->integer clause)))
	 ((cnst? clause)
	  (bit-xor checksum (cnst->integer clause)))
	 ((string? clause)
	  (bit-xor checksum (string->0..2^x-1 clause 16)))
	 ((symbol? clause)
	  (bit-xor checksum (symbol->number clause)))
	 ((pair? clause)
	  (list->number checksum clause))))
   (define (list->number checksum clause)
      (cond
	 ((null? clause)
	  checksum)
	 ((pair? clause)
	  (list->number (atom->number checksum (car clause))
			(cdr clause)))
	 (else
	  (atom->number checksum clause))))
   (list->number checksum clause))
		
