;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Integrate/loc2glo.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 15 17:29:48 1995                          */
;*    Last change :  Thu Jun 11 09:30:53 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We translate a local function definition into a global one.      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_local->global
   (include "Tools/trace.sch")
   (import  tools_shape
	    tools_args
	    module_module
	    type_type
	    type_cache
	    ast_var
	    ast_node
	    ast_glo-def
	    ast_env
	    ast_local
	    integrate_info
	    integrate_node)
   (export  (local->global ::local)
	    (the-global    ::local)))

;*---------------------------------------------------------------------*/
;*    local->global ...                                                */
;*---------------------------------------------------------------------*/
(define (local->global local)
   (trace (integrate 2) (shape local) #\: #\Newline)
   (let* ((global   (the-global local))
	  (kaptured (sfun/Iinfo-kaptured (local-value local)))
	  (add-args (map (lambda (old)
			    (clone-local old
					 (duplicate::svar/Iinfo
					       (local-value old))))
			 kaptured))
	  (old-fun  (local-value local))
	  (new-fun  (duplicate::sfun old-fun
		       (arity (+-arity (sfun-arity old-fun) (length add-args)))
		       (args (append (reverse add-args)
				     (sfun-args old-fun))))))
      ;; we set the result type
      (global-type-set! global (local-type local))
      (for-each (lambda (l)
		   (if (integrate-celled? l)
		       (local-type-set! l *obj*)))
		(sfun-args new-fun))
      (sfun-body-set! new-fun
		      (globalize! (sfun-body old-fun)
				  local
				  (map cons kaptured add-args)))
      (global-value-set! global new-fun)
      global))

;*---------------------------------------------------------------------*/
;*    the-global ...                                                   */
;*---------------------------------------------------------------------*/
(define (the-global local::local)
   (let ((value (local-value local)))
      (if (global? (sfun/Iinfo-global value))
	  (sfun/Iinfo-global value)
	  (let* ((id     (if (global? (find-global (local-id local) *module*))
			     (gensym (symbol-append (local-id local) '_))
			     (local-id local)))
		 (global (def-global-sfun! id
			   ;; we set dummy empty args-id 
			   ;; and dummy empty args because a new-fun
			   ;; will be allocated.
			   '()
			   '()
			   *module*
			   'sfun
			   'a-integrated-body
			   'now
			   #unspecified)))
	     ;; we have to propagate the location definition
	     ;; of the local variable
	     (sfun-loc-set! (global-value global) (sfun-loc value))
	     ;; we check if the function is a user one
	     (if (not (local-user? local))
		 (global-user?-set! global #f))
	     (sfun/Iinfo-global-set! value global)
	     (sfun-side-effect?-set! (global-value global)
				     (sfun-side-effect? value))
	     global))))
