;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Integrate/iinfo.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun 28 14:06:46 1996                          */
;*    Last change :  Fri Jun 28 15:58:51 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The extension for the integrate pass.                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_info
   
   (import  type_type
	    ast_var
	    ast_node)
   
   (export (wide-class svar/Iinfo::svar
	      ;; a stamp to compute free variables
	      (f-mark (default #unspecified))
	      ;; a stamp to compute union of variables
	      (u-mark (default #unspecified))
	      ;; is a local kaptured ?
	      (kaptured?::bool (default #f))
	      ;; celled?
	      (celled?::bool (default #f)))

	   (wide-class sexit/Iinfo::sexit
	      ;; a stamp to compute free variables
	      (f-mark (default #unspecified))
	      ;; a stamp to compute union of variables
	      (u-mark (default #unspecified))
	      ;; is a local kaptured ?
	      (kaptured?::bool (default #f))
	      ;; celled?
	      (celled?::bool (default #f)))

	   (wide-class sfun/Iinfo::sfun
	      ;; the variable which bound the local function
	      owner
	      ;; the free variables
	      (free (default #unspecified))
	      ;; the bound variables list
	      (bound (default '()))
	      ;; the list of variables which calls the fun
	      (cfrom (default '()))
	      ;; the list of variables which are called.
	      (cto (default '()))
	      ;; the K property
	      (K (default '()))
	      ;; the K* property
	      (K* (default '()))
	      ;; the U property
	      (U (default #unspecified))
	      ;; the Cn property
	      (Cn (default '()))
	      ;; the Ct property
	      (Ct (default '()))
	      ;; the variable from which self is the kont.
	      (kont (default '()))
	      ;; is this function globalized ?
	      G?::bool
	      ;; the integrator (if not G?)
	      (L (default #unspecified))
	      ;; the integrated functions (if G?).
	      (Led (default '()))
	      ;; a stamp to integrate functions.
	      (istamp (default #unspecified))
	      ;; a pointer to the globalized function.
	      (global (default #unspecified))
	      ;; the list of the kaptured variables
	      (kaptured (default #unspecified)))))
	      
	   
